/***************************************************************************
 *   Copyright (C) 2003-2004 by David Saxton                               *
 *   david@bluehaze.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef ITEMEDITOR_H
#define ITEMEDITOR_H

#include <tqwidget.h>
#include <tqguardedptr.h>

class ItemEditor;

class CNItem;
class CNItemGroup;
class Item;
class CNItemGroup;
class ICNDocument;
class ItemGroup;
class OrientationWidget;
class PropertiesListView;
class TQPushButton;
class TQLabel;

namespace KateMDI { class ToolView; }

/**
@author Daniel Clarke
@author David Saxton
*/
class ItemEditor : public TQWidget
{
	Q_OBJECT
  
	public:
		static ItemEditor * self( KateMDI::ToolView * parent = 0l );
		~ItemEditor();
		static TQString toolViewIdentifier() { return "ItemEditor"; }
	
	public slots:
		/**
		 * Update the Properties Editor
		 */
		void slotUpdate( ItemGroup *itemGroup );
		/**
		 * Update the orientation widget
		 */
		void slotUpdate( CNItem *item );
		/**
		 * Clear the properties editor and orientation widget
		 */
		void slotClear();
		void slotMultipleSelected();
		/**
		 * Updates the merge / reset data parts (e.g. enabling or disabling the
		 * "Defaults" button)
		 */
		void updateMergeDefaults( ItemGroup *itemGroup );
	
	protected:
		void updateNameLabel( Item *item );
		PropertiesListView * propList;
		static ItemEditor * m_pSelf;
	
	private slots:
		void mergeProperties();
		
	private:
		ItemEditor( KateMDI::ToolView * parent );
	
		TQLabel *m_nameLbl;
		TQPushButton *m_defaultsBtn;
		TQPushButton *m_mergeBtn;
		OrientationWidget *m_orientationWidget;
};


#endif
