/***************************************************************************
 *   Copyright (C) 2005 by David Saxton                                    *
 *   david@bluehaze.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef DRAWPART_H
#define DRAWPART_H

#include <item.h>

class ICNDocument;
class ItemDocument;
class LibraryItem;
class RectangularOverlay;

/**
@author David Saxton
*/
class DrawPart : public Item
{
	public:
		enum DrawAction
		{
		// Note: values are used for popup menu
			da_text = 0,
			da_line = 1,
			da_arrow = 2,
			da_rectangle = 3,
			da_ellipse = 4
		};
		
		DrawPart( ItemDocument *itemDocument, bool newItem, const char *id );
		virtual ~DrawPart();
	
		int rtti() const;

		virtual bool canResize() const { return true; }
		
		virtual Variant * createProperty( const TQString & id, Variant::Type::Value type );
		
		Qt::PenStyle getDataPenStyle( const TQString & id );
		Qt::PenCapStyle getDataPenCapStyle( const TQString & id );
		
		void setDataPenStyle( const TQString & id, Qt::PenStyle value );
		void setDataPenCapStyle( const TQString & id, Qt::PenCapStyle value );
		
		virtual ItemData itemData() const;
		virtual void restoreFromItemData( const ItemData &itemData );
		
		// Convention for following functions: name is i18n'd name of style, id is the english one
		
		static TQString penStyleToID( Qt::PenStyle style );
		static Qt::PenStyle idToPenStyle( const TQString & id );
		static TQString penCapStyleToID( Qt::PenCapStyle style );
		static Qt::PenCapStyle idToPenCapStyle( const TQString & id );
		
		static TQString penStyleToName( Qt::PenStyle style );
		static Qt::PenStyle nameToPenStyle( const TQString & name );
		static TQString penCapStyleToName( Qt::PenCapStyle style );
		static Qt::PenCapStyle nameToPenCapStyle( const TQString & name );
};

#endif
