/***************************************************************************
 *   Copyright (C) 2003-2004 by David Saxton                               *
 *   david@bluehaze.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include "plvitem.h"
#include "variant.h"

#include <tdelistview.h>
#include <tqpainter.h>
#include <tqvariant.h>

//BEGIN class PLVItem
PLVItem::PLVItem(TDEListView *listview, const TQString &id, Variant *data)
	: TDEListViewItem(listview, data->editorCaption())
{
	p_data = data;
	m_id = id;
	setText(1,p_data->displayString() );
	
	connect(data,TQT_SIGNAL(valueChanged(TQVariant, TQVariant )),this,TQT_SLOT(updateData(TQVariant )));
	
	//setHeight(100);
}


PLVItem::~PLVItem()
{
}

void PLVItem::updateData(TQVariant /*value*/)
{
	if (!p_data)
		return;
	setText(1,p_data->displayString() );
}


int PLVItem::width ( const TQFontMetrics & fm, const TQListView * lv, int c ) const
{
	if ( c == 0 )
		return 100;
// 		return TDEListViewItem::width( fm, lv, c );
	else
		return 200;
}
//END class PLVitem



//BEGIN class PLVColorItem
PLVColorItem::PLVColorItem(TDEListView *listview, const TQString &id, Variant *data)
	: PLVItem(listview,id,data)
{
}


PLVColorItem::~PLVColorItem()
{
}

void PLVColorItem::paintCell ( TQPainter * p, const TQColorGroup & cg, int column, int width, int align )
{
	if (!p_data)
		return;
	// we only draw column 1 "Data" ourselves, otherwise
	// we leave it up to KDE
	if (column == 1)
	{
		p->setBackgroundColor( p_data->value().toColor() );
		TQBrush brush( p_data->value().toColor() );
		p->fillRect(TQRect(0,0,listView()->columnWidth(1),TDEListViewItem::height()),brush);
	}
	else
		TDEListViewItem::paintCell(p,cg,column,width,align);
}

void PLVColorItem::updateData(TQVariant value)
{
	listView()->triggerUpdate();
	PLVItem::updateData(value);
}
//END class PLVColorItem

#include "plvitem.moc"
