/***************************************************************************
 *   Copyright (C) 2003-2005 by Michael Goettsche                          *
 *   mail@tuxipuxi.org                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <tdeapplication.h>
#include <tdeaboutdata.h>
#include <tdecmdlineargs.h>

#include "kstreamripper.h"


int main( int argc, char *argv[] )
{
	TDEAboutData aboutApp( "KStreamRipper", I18N_NOOP( "KStreamRipper" ), "0.3.4",
	                     "KStreamRipper is a Frontend to Streamripper. Visit Homepage for more Info.",
	                     TDEAboutData::License_GPL, "(C) 2003-2005 Michael Goettsche", 0,
	                     "http://kstreamripper.tuxipuxi.org", "mail@tuxipuxi.org" );
	
	aboutApp.addAuthor( "Michael Goettsche", "Maintainer, Initial version", "mail@tuxipuxi.org" );
        aboutApp.addAuthor( "William Entriken", "Concurrent Ripping, Major UI improvements", "william.entriken@villanova.edu" );
	aboutApp.addCredit( "Kevin Krammer", "Assistance");
	aboutApp.addCredit( "Jakub Stachowski", "bksys migration, crash fix" );
	TDECmdLineArgs::init( argc, argv, &aboutApp );
	
	TDEApplication app;
	
	KStreamRipper *mainWidget = new KStreamRipper();
	
	app.setMainWidget( mainWidget );
	mainWidget->show();
	
	mainWidget->resize( 700, 600 );
	
	return app.exec();
}















