/*
	progressbar.h - Progress Bar
	Copyright (C) 2006  Konrad Twardowski <kdtonline@poczta.onet.pl>

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __PROGRESSBAR_H__
#define __PROGRESSBAR_H__

#include <tqwidget.h>

#include "progressbar.h"

class ProgressBar: public TQWidget {
	Q_OBJECT
public:
	enum Position { TOP, BOTTOM };
	virtual ~ProgressBar();
	inline static void freeInstance() {
		if (_instance) {
			delete _instance;
			_instance = 0;
		}
	}
	inline static ProgressBar *getInstance() {
		if (!_instance)
			_instance = new ProgressBar();

		return _instance;
	}
	inline static bool isInstance() {
		return _instance;
	}
	inline Position position() const { return _position; }
	void setPosition(const Position value);
	void setHeight(const int value);
	void setProgress(const int complete);
	void setValues(const int complete, const int total);
protected:
	void mousePressEvent(TQMouseEvent *e);
	void paintEvent(TQPaintEvent *);
private:
	int _complete;
	int _total;
	Position _position;
	static ProgressBar *_instance;
	ProgressBar();
private slots:
	void slotSetBottomPosition();
	void slotSetTopPosition();
};

#endif // __PROGRESSBAR_H__
