/*
	mmessagedialog.cpp - A warning message dialog
	Copyright (C) 2004  Konrad Twardowski <kdtonline@poczta.onet.pl>

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "miscutils.h"
#include "mmainwindow.h"
#include "mmessagedialog.h"

#include <ntqdatetime.h>
#include <ntqhbox.h>
#include <ntqlabel.h>
#include <ntqlayout.h>
#include <ntqlcdnumber.h>
#include <ntqtimer.h>

#include <kdebug.h>
#include <kiconloader.h>
#include <tdelocale.h>
#include <tdepopupmenu.h>
#include <kpushbutton.h>
#include <twin.h>

// public

MMessageDialog *MMessageDialog::_instance = 0;

MMessageDialog::MMessageDialog(const int delay, const Action::Type actionToExecute, const TQString &text)
	: KDialog(ks_main, "MMessageDialog", true),
	_dialogDelay(delay),
	_lastTime(-1),
	_action(actionToExecute)
{
	setCaption(i18n("Message"));
	setPaletteBackgroundColor(yellow);
	setPaletteForegroundColor(black);

	// main layout
	TQVBoxLayout *l = new TQVBoxLayout(this, 5);

	// message text
	TQLabel *t_message = new TQLabel(this);
	TQFont f = TQFont(t_message->font());
	f.setPointSize(16);
	t_message->setFont(f);
	t_message->setPaletteBackgroundColor(yellow);
	t_message->setPaletteForegroundColor(black);
	t_message->setAlignment(AlignCenter);
	t_message->setFrameShape(TQFrame::StyledPanel);
	t_message->setFrameShadow(TQFrame::Plain);
	t_message->setLineWidth(4);
	t_message->setMargin(20);
	t_message->setSizePolicy(TQSizePolicy(TQSizePolicy::Preferred, TQSizePolicy::Expanding));
	t_message->setText(text);

	// bottom layout
	TQHBox *bottomBox = new TQHBox(this);
	bottomBox->setSpacing(5);

	// seconds
	l_seconds = new TQLCDNumber(bottomBox);
	l_seconds->display(_dialogDelay);
	l_seconds->setFrameShape(TQFrame::NoFrame);
	l_seconds->setSegmentStyle(TQLCDNumber::Flat);
	MiscUtils::setHint(l_seconds, i18n("Remaining time."));

	// continue button
	b_continue = new KPushButton(
		ks_actions->getIcon(_action), ks_actions->getName(_action),
		bottomBox, "KPushButton::b_continue"
	);
// FIXME: 2.0: no accelerator for "b_continue"
	b_continue->setPaletteBackgroundColor(yellow);
	b_continue->setPaletteForegroundColor(black);
	connect(b_continue, SIGNAL(clicked()), SLOT(slotAccept()));
	b_continue->setEnabled(false);
	TQTimer::singleShot(2000, this, SLOT(slotEnableContinue()));

	// cancel button
	KPushButton *b_cancel = new KPushButton(KStdGuiItem::cancel(), bottomBox, "KPushButton::b_cancel");
	b_cancel->setDefault(true);
	b_cancel->setPaletteBackgroundColor(yellow);
	b_cancel->setPaletteForegroundColor(black);
	connect(b_cancel, SIGNAL(clicked()), SLOT(slotReject()));

	l->addWidget(t_message);
	l->addWidget(bottomBox);

	// init time checker
	_checkTimer = new TQTimer(this);
	connect(_checkTimer, SIGNAL(timeout()), SLOT(slotCheckTime()));
	_checkTimer->start(500);

	setFixedSize(sizeHint());

	// make sure it is visible
	// code from KAlarm
	WId id = winId();
	KWin::setState(id, NET::StaysOnTop | NET::Sticky);
	KWin::setOnAllDesktops(id, true);
}

MMessageDialog::~MMessageDialog()
{
	// kdDebug() << "MMessageDialog::~MMessageDialog()" << endl;
}

void MMessageDialog::cancel() {
	if (_instance) {
		// kdDebug() << "MMessageDialog::cancel()" << endl;
		_instance->slotReject();
		delete _instance;
		_instance = 0;
	}
}

bool MMessageDialog::show(const int timeout) {
	cancel();
	KWin::setOnDesktop(ks_main->winId(), KWin::currentDesktop());
	// show warning message dialog
	_instance = new MMessageDialog(
		timeout,
		ks_actions->current(),
		ks_actions->getCurrentName()
	);
	bool result = (_instance->exec() == Accepted);
	delete _instance;
	_instance = 0;

	// kdDebug() << "result = " << result << endl;

	return result;
}

// private slots

void MMessageDialog::slotAccept() {
	done(Accepted);
}

void MMessageDialog::slotEnableContinue() {
	b_continue->setEnabled(true);
}

void MMessageDialog::slotCheckTime()
{
	TQTime t = TQTime::currentTime();

	if (t.second() == _lastTime)
		return;

	l_seconds->display(_dialogDelay);

	// timeout?
	if (_dialogDelay == 0)
	{
		slotAccept();

		return;
	}

	MiscUtils::notifyUser(_dialogDelay);

	_lastTime = t.second();
	_dialogDelay--;
}

void MMessageDialog::slotReject() {
	done(Rejected);
}
