/***************************************************************************
                          kshowmaildoc.h  -  description
                             -------------------
    begin                : Fre Sep 28 23:29:54 CEST 2001
    copyright            : (C) 2001 by Eggert Ehmke
    email                : eggert.ehmke@berlin.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KSHOWMAILDOC_H
#define KSHOWMAILDOC_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

// include files for QT
#include <ntqobject.h>
#include <ntqstring.h>

// include files for KDE
#include <kurl.h>

// forward declaration of the Kshowmail classes
class KshowmailView;

/**	KshowmailDoc provides a document object for a document-view model.
  *
  * The KshowmailDoc class provides a document object that can be used in conjunction with the classes KshowmailApp and KshowmailView
  * to create a document-view model for standard KDE applications based on TDEApplication and TDEMainWindow. Thereby, the document object
  * is created by the KshowmailApp instance and contains the document structure with the according methods for manipulation of the document
  * data by KshowmailView objects. Also, KshowmailDoc contains the methods for serialization of the document data from and to files.
  *
  * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team. 	
  * @version KDevelop version 1.2 code generation
  */
class KshowmailDoc : public TQObject
{
  Q_OBJECT
  public:
    /** Constructor for the fileclass of the application */
    KshowmailDoc(TQWidget *parent, const char *name=0);
    /** Destructor for the fileclass of the application */
    ~KshowmailDoc();

    /** adds a view to the document which represents the document contents. Usually this is your main view. */
    void addView(KshowmailView *view);
    /** removes a view from the list of currently connected views */
    void removeView(KshowmailView *view);
    /** initializes the document generally */
    bool newDocument();
    /** returns the KURL of the document */
    const KURL& URL() const;
    /** sets the URL of the document */
	  void setURL(const KURL& url);
	
  public slots:
    /** calls repaint() on all views connected to the document object and is called by the view by which the document has been changed.
     * As this view normally repaints itself, it is excluded from the paintEvent.
     */
    void slotUpdateAllViews(KshowmailView *sender);
 	
  public:	
    /** the list of the views currently connected to the document */
    // no List; just one view
    static KshowmailView *pView;	

  private:
    /** the modified flag of the current document */
    KURL doc_url;
};

#endif // KSHOWMAILDOC_H
