//
// C++ Interface: filterlogviewdeleteditem
//
// Description:
//
//
// Author: Ulrich Weigelt <ulrich.weigelt@gmx.de>, (C) 2008
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef FILTERLOGVIEWDELETEDITEM_H
#define FILTERLOGVIEWDELETEDITEM_H

//TQt Headers
#include <ntqdatetime.h>

//KDE headers
#include <tdelistview.h>

/**
 * @brief Item of the filter log view of deleted mails
 * @author Ulrich Weigelt <ulrich.weigelt@gmx.de>
 */
class FilterLogViewDeletedItem : public TDEListViewItem
{

  public:

    /**
     * Column Numbers.
     */
    enum Column{ ColDate = 0, ColSender = 1, ColAccount = 2, ColSubject = 3 };

    /**
     * Constructor
     * @param parent the log view of this items
     */
    FilterLogViewDeletedItem( TDEListView* parent );

    /**
     * Destrutor
     */
    ~FilterLogViewDeletedItem();

    /**
     * Sets the column values.
     * @param date date and time at which the mail was sent
     * @param sender sender of the mail
     * @param account account
     * @param subject mail subject
     */
    void setValues( TQDateTime date, TQString sender, TQString account, TQString subject );

    /**
     * Reimplemantation of TQListViewItem::compare.
     * Compares this list view item to i using the column col in ascending order. Returns <0 if this item is less than i,
     * 0 if they are equal and >0 if this item is greater than i. The parameter ascneding will be ignored.
     * @param i pointer to the second view item
     * @param col number of the sorted column
     * @param ascending ignored
     */
    virtual int compare( TQListViewItem* i, int col, bool ascending ) const;

    /**
     * Returns the date of sent
     * @return date of sent
     */
    TQDateTime getDate();


  private:

    /**
     * sent date and time
     */
    TQDateTime date;

    /**
     * sender of the mail
     */
    TQString sender;

    /**
     * Account
     */
    TQString account;

    /**
     * mail subject
     */
    TQString subject;
};

#endif
