//
// C++ Interface: filteritem
//
// Description:
//
//
// Author: Ulrich Weigelt <ulrich.weigelt@gmx.de>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef FILTERITEM_H
#define FILTERITEM_H

//TQt headers
#include <ntqstring.h>
#include <ntqptrlist.h>

//KDE headers
#include <tdeapplication.h>
#include <kdebug.h>
#include <tdeconfig.h>

//KShowmail headers
#include "filteritemcriteria.h"
#include "constants.h"
#include "types.h"

using namespace Types;

/**
 * This is a filter item. It contains a list of criterias (class FilterItemCriteria).
 * @author Ulrich Weigelt <ulrich.weigelt@gmx.de>
 */
class FilterItem{

  public:

    /**
     * Constructor
     * Loads the settings from the config file
     * @param filterNr Number of the filter
     */
    FilterItem( uint filterNr );

    /**
     * Destructor
     */
    ~FilterItem();

    /**
     * Prints the settings.
     */
    void print() const;

    /**
     * Checks the given mail header.
     * @param from Sender
     * @param to Addressee
     * @param size Size
     * @param subject Subject
     * @param header Header
     * @param account Account
     * @param mailboxName contains the mailbox name after call, if filter action is MOVE
     * @return recommend action
     */
    FilterAction_Type check( TQString from, TQString to, uint size, TQString subject, TQString header, TQString account, TQString& mailboxName ) const;

  private:

    /**
     * Connector to the configuration file
     */
    TDEConfig* config;

    /**
     * Filter number. Just for messages.
     */
    uint filterNumber;

    /**
     * Filter name. Just for messages.
     */
    TQString name;

    /**
     * Number of criterias
     */
    uint numberCriterias;

    /**
     * Type of criteria linkage
     */
    enum Linkage_Type{ LinkAll, LinkAny };

    /**
     * Criteria Linkage
     */
    Linkage_Type linkage;

    /**
     * Filter Action
     */
    FilterAction_Type action;

    /**
     * Mailbox Name for move action
     */
    TQString mailbox;

    /**
     * This list holds the criterias.
     */
    TQPtrList<FilterItemCriteria> criterias;
};

#endif
