/***************************************************************************
                          kshowmailview.h  -  description
                             -------------------
    begin                : Sat May  6 12:13:57 MEST 2000
    copyright            : (C) 2000-2001 by Eggert Ehmke
    email                : eggert.ehmke@berlin.de

    26 Sep 2002 - Allow for columns to be hidden. Allistar Melville
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KSHOWMAILVIEW_H
#define KSHOWMAILVIEW_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

//TQt headers
#include <ntqwidget.h>
#include <ntqsplitter.h>
#include <ntqcursor.h>
#include <ntqpopupmenu.h>

//KDE headers
#include <tdelistview.h>
#include <tdeconfig.h>
#include <tdeapplication.h>

//KShowmail headers
#include "configlist.h"
#include "showlistviewitem.h"



class ConfigList;
class KshowmailDoc;

/** The KshowmailView class provides the view widget for the KShowMailApp instance.
 * The View instance inherits TQWidget as a base class and represents the view object of a TDEMainWindow.
 * As KshowmailView is part of the document-view model, it needs a reference to the document object
 * connected with it by the KShowMailApp class to manipulate and display
 * the document structure provided by the KshowmailDoc class.
 *
 * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
 * @author Ulrich Weigelt <ulrich.weigelt@gmx.de>
 * @version KDevelop version 0.4 code generation
 */
class KshowmailView : public TQSplitter
{
  Q_OBJECT

  public:

    /**
     * Constructor for the main view
     */
    KshowmailView(TQWidget *parent = 0, const char *name=0);


    /**
     * Destructor for the main view
     */
    ~KshowmailView();

    /**
     * Saves the options
     */
    void saveOptions( TDEConfig* config );

    /**
     * Clears the mail list view.
     */
    void clearMailListView();

    /**
     * Creates a mail list view item with the given content and
     * inserts it into the mail list view.
     * @param number mail number
     * @param account account name
     * @param from sender of the mail
     * @param to recipient of the mail
     * @param subject mail subject
     * @param date date on which the mail was sent, formated to the current locale's conventions.
     * @param size size of the mail
     * @param content content type
     * @param state new or old
     * @param time send date, formated to the ISO 8601 extended specification (YYYY-MM-DDTHH:MM:SS)
     * @return pointer to the created list view item
     */
    ShowListViewItem* insertMail( TQString& number, TQString& account, TQString& from, TQString& to, TQString& subject, TQString& date, TQString& size, TQString& content, TQString& state, TQString& time );

    /**
     * Refreshes the geometry.
     * Reads from the config file the properties about show or hide columns.
     * If a shown column should be hidden, the current width will be saved and the column will be hidden.
     * If a hidden column should be shown, it will be set to the old saved width.
     */
    void refreshSetup();

    TDEListView* m_pListAccounts;
    TDEListView* m_pListMessages;

  private:

    TQPixmap* m_pixOk;

    /**
     * Connector to the configuration file
     */
    TDEConfig* config;

    /**
     * Reads the some geometry options from the application config file.
     */
    void readOptions();

private slots:

  /**
   * Connected with signal rightButtonClicked of m_pListMessages.
   * Invoked, when the user has clicked on a list item with the right mouse button.
   * Selects the clicked item and shows the popup menu mail_context_popup defined in
   * kshowmailui.rc.
   */
  void slotMessageContext( TQListViewItem*, const TQPoint&, int );

	void slotMessageDoubleClicked (TQListViewItem*);
	void slotMessageClicked (TQListViewItem*);

  /**
   * Connected with signal rightButtonClicked of m_pListAccounts.
   * Invoked, when the user has clicked on a list item with the right mouse button.
   * Selects the clicked item and shows the popup menu account_context_popup defined in
   * kshowmailui.rc.
   */
  void slotAccountContext( TQListViewItem*, const TQPoint &, int );

  /**
   * Connected with signal clicked of the account list.
   * Activate or deactivate the account, if the user has clicked in the first column
   */
  void slotAccountClicked( TQListViewItem*, const TQPoint& point, int col );

signals:
	void signalActiveChanged ();
};

#endif // KSHOWMAILVIEW_H
