/***************************************************************************
                          kshowmaildoc.cpp  -  description
                             -------------------
    begin                : Fre Sep 28 23:29:54 CEST 2001
    copyright            : (C) 2001 by Eggert Ehmke
    email                : eggert.ehmke@berlin.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// include files for TQt
#include <ntqdir.h>
#include <ntqwidget.h>

// include files for KDE
#include <tdelocale.h>
#include <tdemessagebox.h>
#include <tdeio/job.h>
#include <tdeio/netaccess.h>

// application specific includes
#include "kshowmaildoc.h"
#include "kshowmail.h"
#include "kshowmailview.h"

KshowmailView *KshowmailDoc::pView = 0L;

KshowmailDoc::KshowmailDoc(TQWidget *parent, const char *name) : TQObject(parent, name)
{
}

KshowmailDoc::~KshowmailDoc()
{
}

void KshowmailDoc::addView(KshowmailView *view)
{
  pView = view;
}

void KshowmailDoc::removeView(KshowmailView*)
{
  delete pView;
}

void KshowmailDoc::setURL(const KURL &url)
{
  doc_url=url;
}

const KURL& KshowmailDoc::URL() const
{
  return doc_url;
}

// this could be deleted; perhaps we build a tree view sometime ?
void KshowmailDoc::slotUpdateAllViews(KshowmailView *sender)
{
  if(pView)
  {
     if(pView!=sender)
        pView->repaint();
  }
}

bool KshowmailDoc::newDocument()
{
  /////////////////////////////////////////////////
  // TODO: Add your document initialization code here
  /////////////////////////////////////////////////
  doc_url.setFileName(i18n("Untitled"));

  return true;
}
