//
// C++ Interface: showmaildialog
//
// Description:
//
//
// Author: Ulrich Weigelt <ulrich.weigelt@gmx.de>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef SHOWMAILDIALOG_H
#define SHOWMAILDIALOG_H

//QT headers
#include <ntqlayout.h>
#include <ntqlabel.h>

//KDE headers
#include <tdelocale.h>
#include <kdialogbase.h>
#include <klineedit.h>
#include <kdebug.h>
#include <ktextbrowser.h>
#include <kurl.h>
#include <tdeapplication.h>

//KShowmail headers
#include "constants.h"

/**
 * This dialog is used in ConfigElem to show a downloaded mail.
 *
 * @author Ulrich Weigelt <ulrich.weigelt@gmx.de>
*/
class ShowMailDialog : public KDialogBase
{

Q_OBJECT

public:

  /**
   * generic constructor
   * @param parent parent of the dialog
   * @param caption the dialog caption
   * @param allowHTML TRUE - allow the dialog to use the HTML in the mail body; FALSE - don't allow
   * @param sender mail sender
   * @param date date of send
   * @param size mail size
   * @param subject mail subject
   * @param body mail body
   */
  ShowMailDialog( TQWidget* parent, TQString& caption, bool allowHTML, TQString& sender, TQString& date, TQString& size, TQString& subject, TQString& body );

  /**
   * Destructor
   */
  ~ShowMailDialog();

private:

  /**
   * mail subject
   * Stored by constructor and used by slotUser1.
   */
  TQString m_subject;

  /**
   * mail body
   * Stored by constructor and used by slotUser1.
   */
  TQString m_body;

  /**
   * mail sender
   * Stored by constructor and used by slotUser1.
   */
  TQString m_sender;

  /**
   * Overloaded methode of KDialogBase.
   * Will be invoked, when reply button was clicked.
   * Starts the composer of the preset mail application which contains
   * the necessary data for a reply.
   */
  void slotUser1();
};

#endif
