/*
 *   File name:	kshowmailfeedback.cpp
 *   Summary:	User feedback questions for KShowmail
 *   License:	GPL - See file COPYING for details.
 *
 *   Author:	Stefan Hundhammer <sh@suse.de>
 *            Eggert Ehmke <eggert.ehmke@berlin.de>
 *
 *   Updated:	2002-05-30
 *
 *   $Id: kshowmailfeedback.cpp,v 1.8 2008/04/17 20:13:20 kuddel-fl Exp $
 *
 */


#include <tdelocale.h>

#include "kshowmail.h"
#include "kfeedback.h"



void KShowMailApp::slotSendFeedbackMail()
{
  KFeedbackDialog* feedbackDialog = new KFeedbackDialog( "eggert.ehmke@berlin.de, ulrich.weigelt@gmx.de", "feedback_mail" );
	CHECK_PTR( feedbackDialog );

	KFeedbackQuestionList * list = feedbackDialog->form()->questionList();

	KFeedbackQuestion * question =
	    list->addQuestion( i18n( "What is your general opinion about this program?" ), "general_opinion", true, true );

	question->addAnswer( i18n( "It's one of my favourites"),                "1/8_favourite");
	question->addAnswer( i18n( "I like it"),                                "2/8_like_it");
	question->addAnswer( i18n( "It's sometimes useful"),                    "3/8_sometimes_useful");
	question->addAnswer( i18n( "It's average"),                             "4/8_average");
	question->addAnswer( i18n( "Nice try, but this could be done better"),  "5/8_nice_try");
	question->addAnswer( i18n( "It's poor"),                                "6/8_poor");
	question->addAnswer( i18n( "It's useless"),                             "7/8_useless");
	question->addAnswer( i18n( "It's crap"),                                "8/8_crap");

	question = list->addQuestion( i18n( "Which features of this program do you like?" ), "features_liked", false );
	addFeatureList( question );

	question = list->addQuestion( i18n( "What is your favourite feature?" ), 	"favourite_feature",	true );
	addFeatureList( question );

	question = list->addQuestion( i18n( "Which features don't you like?" ), 	"features_not_liked",	false );
	addFeatureList( question );

	question = list->addQuestion( i18n( "Which features do you never use?" ), 	"features_never_used",	false );
	addFeatureList( question );

	question = list->addQuestion( i18n( "Are there features you are missing?" ),	"features_missing",	true );
	question->addAnswer( i18n( "Yes, a lot! (please add comment below)"	),	"1/4_lots"		);
	question->addAnswer( i18n( "Some (please add comment below)"		),	"2/4_some"		);
	question->addAnswer( i18n( "None"					),	"3/4_none"		);
	question->addAnswer( i18n( "It has too many features already!"		),	"4/4_too_many_already"	);

	question = list->addQuestion( i18n( "How do you rate the stability of this program?" ),	"stability",	true, true );
	question->addAnswer( i18n( "Rock solid"),                     "1/5_rock_solid"		);
	question->addAnswer( i18n( "Good"),                           "2/5_good");
	question->addAnswer( i18n( "Average"),                        "3/5_average");
	question->addAnswer( i18n( "Poor"),                           "4/5_poor"		);
	question->addAnswer( i18n( "It keeps crashing all the time"), "5/5_keeps_crashing"	);

	question = list->addQuestion( i18n( "How do you rate the performance of this program?" ), "performance", true );
	question->addAnswer( i18n( "Great"),                          "1/5_great");
	question->addAnswer( i18n( "Good"),                           "2/5_good");
	question->addAnswer( i18n( "Average"),                        "3/5_average");
	question->addAnswer( i18n( "Poor"),                           "4/5_poor");
	question->addAnswer( i18n( "It's so slow it drives me nuts"), "5/5_drives_me_nuts");

	question = list->addQuestion( i18n( "What is your experience with computers in general?" ), "computer_experience", true );
	question->addAnswer( i18n( "Expert"					),	"1/5_expert"		);
	question->addAnswer( i18n( "Fair"					),	"2/5_fair"		);
	question->addAnswer( i18n( "Average"					),	"3/5_average"		);
	question->addAnswer( i18n( "Learning"					),	"4/5_learning"	);
	question->addAnswer( i18n( "Newbie"					),	"5/5_newbie"		);

	question = list->addQuestion( i18n( "What is your experience with Unix/Linux systems?" ), "unix_experience", true );
	question->addAnswer( i18n( "Expert"					),	"1/5_expert"		);
	question->addAnswer( i18n( "Fair"					),	"2/5_fair"		);
	question->addAnswer( i18n( "Average"					),	"3/5_average"		);
	question->addAnswer( i18n( "Learning"					),	"4/5_learning"	);
	question->addAnswer( i18n( "Newbie"					),	"5/5_newbie"		);

	question = list->addQuestion( i18n( "Did you have trouble figuring out how to work with this program?" ),
				      "learning_curve", true, true );
	question->addAnswer( i18n( "No problem"					),	"1/5_no_problem"	);
	question->addAnswer( i18n( "Some"					),	"2/5_some_problems"	);
	question->addAnswer( i18n( "I'm still learning"				),	"3/5_still_learing"	);
	question->addAnswer( i18n( "I didn't have a clue what to do at first"	),	"4/5_no_clue_at_first"	);
	question->addAnswer( i18n( "I still don't have a clue what to do"	),	"5/5_still_no_clue"	);

	question = list->addQuestion( i18n( "Where do you use this program most?" ),	"usage_where", 		true );
	question->addAnswer( i18n( "At work"					),	"at_work"		);
	question->addAnswer( i18n( "At home"					),	"at_home"		);
	question->addAnswer( i18n( "At university / school"			),	"university"		);

	question = list->addQuestion( i18n( "What is your primary role there?"	),	"primary_role",		true );
	question->addAnswer( i18n( "Home user"					),	"home_user"		);
	question->addAnswer( i18n( "Student"					),	"student"		);
	question->addAnswer( i18n( "Educational (teacher / professor)"		),	"educational"		);
	question->addAnswer( i18n( "Non-computer related work"			),	"non_computer"		);
	question->addAnswer( i18n( "Developer"					),	"developer"		);
	question->addAnswer( i18n( "System administrator"			),	"sysadmin"		);

	question = list->addQuestion( i18n( "Do you have any other roles there?" ),	"other_roles",		false );
	question->addAnswer( i18n( "Home user"					),	"home_user"		);
	question->addAnswer( i18n( "Student"					),	"student"		);
	question->addAnswer( i18n( "Educational (teacher / professor)"		),	"educational"		);
	question->addAnswer( i18n( "Non-computer related work"			),	"non_computer"		);
	question->addAnswer( i18n( "Developer"					),	"developer"		);
	question->addAnswer( i18n( "System administrator"			),	"sysadmin"		);

	question = list->addQuestion( i18n( "How did you get to know this program?" ),	"first_contact",	true );
	question->addAnswer( i18n( "In a menu on my machine"			),	"menu"			);
	question->addAnswer( i18n( "Somebody told me about it"			),	"told"			);
	question->addAnswer( i18n( "On the internet"				),	"internet"		);
	question->addAnswer( i18n( "Printed magazine / book"			),	"print_media"		);
	question->addAnswer( i18n( "Other (please add comment below)"		),	"other"			);

	list->addYesNoQuestion( i18n( "Would you recommend this program to a friend?" ), "recommend", true );

  feedbackDialog->show();
}


void KShowMailApp::addFeatureList( KFeedbackQuestion * question )
{
    question->addAnswer( i18n( "The message list display in general"),	"message_list"		);
    question->addAnswer( i18n( "Display of message headers" ),          "message_header" 	);
    question->addAnswer( i18n( "Display of complete messages"),         "complete_message"		);

    question->addAnswer( i18n( "Filters" ), "filters" );
    question->addAnswer( i18n( "Manual delete of unwanted messages"),     "manual_delete_messages"	);
    question->addAnswer( i18n( "Automatic move of filtered messages" ), "move_messages" );
    question->addAnswer( i18n( "Automatic delete of filtered messages" ), "delete_messages" );
    question->addAnswer( i18n( "Automatic mark of filtered messages" ), "mark_messages" );
    question->addAnswer( i18n( "Ignoring of filtered messages" ), "ignoring_messages" );
    question->addAnswer( i18n( "Integration of SpamAssassin" ), "SpamAssassin_Integration" );
    question->addAnswer( i18n( "White- and Blacklist" ), "white_blacklist" );
    question->addAnswer( i18n( "Filter Log" ), "filter_log" );
    question->addAnswer( i18n( "Filter messages by regular expressions"), "filter_messages_by regular_expression"	);


    question->addAnswer( i18n( "Sorting of messages by size, date etc."		),	"sorting"	);

    question->addAnswer( i18n( "Play sound"),               "play_sound"		);
    question->addAnswer( i18n( "Play beep"),                "play_beep"	);
    question->addAnswer( i18n( "Initial timer"),            "initial_timer"	);
    question->addAnswer( i18n( "Interval timer"),           "interval_timer"		);
    question->addAnswer( i18n( "This feedback survey :-)"), "feedback"		);
}



// EOF
