//
// C++ Interface: filterlogviewmoveditem
//
// Description:
//
//
// Author: Ulrich Weigelt <ulrich.weigelt@gmx.de>, (C) 2008
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef FILTERLOGVIEWMOVEDITEM_H
#define FILTERLOGVIEWMOVEDITEM_H

//TQt Headers
#include <ntqdatetime.h>

//KDE headers
#include <tdelistview.h>

/**
 * @brief Item of the filter log view of moved mails
 * @author Ulrich Weigelt <ulrich.weigelt@gmx.de>
 */
class FilterLogViewMovedItem : public TDEListViewItem
{

  public:

  /**
   * Column Numbers.
   */
    enum Column{ ColDate = 0, ColSender = 1, ColAccount = 2, ColMailbox = 3, ColSubject = 4 };

    /**
     * Constructor
     * @param parent the log view of this items
     */
    FilterLogViewMovedItem( TDEListView* parent);

    /**
     * Destructor
     */
    ~FilterLogViewMovedItem();

    /**
     * Sets the column values.
     * @param date date and time at which the mail was sent
     * @param sender sender of the mail
     * @param account account
     * @param mailbox mailbox to which the mail was moved
     * @param subject mail subject
     */
    void setValues( TQDateTime date, TQString sender, TQString account, TQString mailbox, TQString subject );

    /**
     * Reimplemantation of TQListViewItem::compare.
     * Compares this list view item to i using the column col in ascending order. Returns <0 if this item is less than i,
     * 0 if they are equal and >0 if this item is greater than i. The parameter ascneding will be ignored.
     * @param i pointer to the second view item
     * @param col number of the sorted column
     * @param ascending ignored
     */
    virtual int compare( TQListViewItem* i, int col, bool ascending ) const;

    /**
     * Returns the date of sent
     * @return date of sent
     */
    TQDateTime getDate();


  private:

    /**
   * sent date and time
     */
    TQDateTime date;

    /**
     * sender of the mail
     */
    TQString sender;

    /**
     * Account
     */
    TQString account;

    /**
     * mail subject
     */
    TQString subject;

    /**
     * mailbox
     */
    TQString mailbox;
};

#endif
