//
// C++ Implementation: filterlogview
//
// Description:
//
//
// Author: Ulrich Weigelt <ulrich.weigelt@gmx.de>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "filterlogview.h"

FilterLogView::FilterLogView( TQWidget *parent, FilterLog* log )
  : KDialogBase( parent, "FilterLogView", true, TQString::null, Ok, Ok, true )
{
  //save the log pointer
  this->log = log;

  //set caption
  setCaption( i18n( "Filter Log View" ) );

  //main widget
  TQWidget* pgMain = new TQWidget( this );
  setMainWidget( pgMain );

  //basic layout
  TQVBoxLayout* layMain = new TQVBoxLayout( pgMain, 0, spacingHint() );

  //view of deleted views
  TQLabel* lblDeletedMails = new TQLabel( i18n( "Deleted Mails:"), pgMain, "lblDeletedMails" );
  layMain->addWidget( lblDeletedMails );

  lstViewDeleted = new TDEListView( pgMain, "lstViewDeleted" );
  lstViewDeleted->addColumn( i18n( "Date" ) );
  lstViewDeleted->addColumn( i18n( "Sender" ) );
  lstViewDeleted->addColumn( i18n( "Account" ) );
  lstViewDeleted->addColumn( i18n( "Subject" ) );
  lstViewDeleted->setColumnWidthMode( 0, TQListView::Maximum );
  lstViewDeleted->setColumnWidthMode( 1, TQListView::Maximum );
  lstViewDeleted->setColumnWidthMode( 2, TQListView::Maximum );
  lstViewDeleted->setColumnWidthMode( 3, TQListView::Maximum );
  lstViewDeleted->setResizeMode( TQListView::NoColumn );
  lstViewDeleted->setSortColumn( 0 );
  lstViewDeleted->setSortOrder( TQt::Ascending );
  layMain->addWidget( lstViewDeleted );

  KPushButton* btnClearDeleted = new KPushButton( KStdGuiItem::clear(), pgMain, "btnClearDeleted" );
  TQToolTip::add( btnClearDeleted, i18n( "Clear the list of deleted mails" ) );
  connect( btnClearDeleted, SIGNAL( clicked() ), this, SLOT( slotClearDeletedMails() ) );
  btnClearDeleted->setSizePolicy( TQSizePolicy::Maximum, TQSizePolicy::Fixed );
  layMain->addWidget( btnClearDeleted );

  //create a seperator
  layMain->addWidget( new KSeparator( pgMain ) );

  //view of deleted views
  TQLabel* lblMovedMails = new TQLabel( i18n( "Moved Mails:"), pgMain, "lblMovedMails" );
  layMain->addWidget( lblMovedMails );

  lstViewMoved = new TDEListView( pgMain, "lstViewMoved" );
  lstViewMoved->addColumn( i18n( "Date" ) );
  lstViewMoved->addColumn( i18n( "Sender" ) );
  lstViewMoved->addColumn( i18n( "Account" ) );
  lstViewMoved->addColumn( i18n( "Moved To" ) );
  lstViewMoved->addColumn( i18n( "Subject" ) );
  lstViewMoved->setColumnWidthMode( 0, TQListView::Maximum );
  lstViewMoved->setColumnWidthMode( 1, TQListView::Maximum );
  lstViewMoved->setColumnWidthMode( 2, TQListView::Maximum );
  lstViewMoved->setColumnWidthMode( 3, TQListView::Maximum );
  lstViewMoved->setColumnWidthMode( 4, TQListView::Maximum );
  lstViewMoved->setResizeMode( TQListView::NoColumn );
  lstViewMoved->setSortColumn( 0 );
  lstViewMoved->setSortOrder( TQt::Ascending );
  layMain->addWidget( lstViewMoved );

  KPushButton* btnClearMoved = new KPushButton( KStdGuiItem::clear(), pgMain, "btnClearMoved" );
  TQToolTip::add( btnClearMoved, i18n( "Clear the list of moved mails" ) );
  connect( btnClearMoved, SIGNAL( clicked() ), this, SLOT( slotClearMovedMails() ) );
  btnClearMoved->setSizePolicy( TQSizePolicy::Maximum, TQSizePolicy::Fixed );
  layMain->addWidget( btnClearMoved );

  //now we load the content for the list views
  LogEntryList listDeletedMails = log->getDeletedMails();
  LogEntryList::iterator it;
  for( it = listDeletedMails.begin(); it != listDeletedMails.end(); it++ )
  {
    //create a new list view item
    FilterLogViewDeletedItem* item = new FilterLogViewDeletedItem( lstViewDeleted );
    item->setValues( (*it).getDate(), (*it).getSender(), (*it).getAccount(), (*it).getSubject() );
  }

  LogEntryList listMovedMails = log->getMovedMails();
  for( it = listMovedMails.begin(); it != listMovedMails.end(); it++ )
  {
    //create a new list view item
    FilterLogViewMovedItem* item = new FilterLogViewMovedItem( lstViewMoved );
    item->setValues( (*it).getDate(), (*it).getSender(), (*it).getAccount(), (*it).getMailbox(), (*it).getSubject() );
  }
}


FilterLogView::~FilterLogView()
{
}

void FilterLogView::slotClearDeletedMails( )
{
  log->clearDeletedMailsLog();
  lstViewDeleted->clear();

}

void FilterLogView::slotClearMovedMails( )
{
  log->clearMovedMailsLog();
  lstViewMoved->clear();
}


#include "filterlogview.moc"
