//
// C++ Interface: configdisplay
//
// Description:
//
//
// Author: Ulrich Weigelt <ulrich.weigelt@gmx.de>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef CONFIGDISPLAY_H
#define CONFIGDISPLAY_H

//TQt headers
#include <tqlayout.h>
#include <tqgroupbox.h>
#include <tqcheckbox.h>
#include <tqlabel.h>
#include <tqtooltip.h>

//KDE headers
#include <tdecmodule.h>
#include <tdeconfig.h>
#include <kgenericfactory.h>
#include <tdeapplication.h>

//KShowmail headers
#include <../constants.h>


/**
 * @brief Part of the setup dialog (KShowMailApp::SetupDialog) to configure the display.
 * @author Ulrich Weigelt <ulrich.weigelt@gmx.de>
 */
class ConfigDisplay : public TDECModule
{
Q_OBJECT

  public:
    /**
     * Generic Constructor
     */
    ConfigDisplay( TQWidget *parent = 0, const char *name = 0, const TQStringList &args = TQStringList() );

    /**
     * Destructor
     */
    ~ConfigDisplay();

    /**
     * Overloaded method of TDECModule.
     * Sets the user interface elements to reflect the current settings stored in the
     * config file.
     */
    virtual void load();

    /**
     * Overloaded method of TDECModule.
     * Sets the user interface elements to default values.
     * This method is called when the user clicks the "Default" button.
     */
    virtual void defaults();

    /**
     * Overloaded method of TDECModule.
     * Stores the config information as shown in the user interface in the
     * config file.
     * Is called when the user clicks "Apply" or "Ok".
     */
    virtual void save();

  private:

    /**
     * Connector to the configuration file
     */
    TDEConfig* config;

    /**
     * Check box to switch on/off the "Active" column in the account list.
     */
    TQCheckBox* chkAccountlistActive;

    /**
     * Check box to switch on/off the "Account" column in the account list.
     */
    TQCheckBox* chkAccountlistAccount;

    /**
     * Check box to switch on/off the "Server" column in the account list.
     */
    TQCheckBox* chkAccountlistServer;

    /**
     * Check box to switch on/off the "User" column in the account list.
     */
    TQCheckBox* chkAccountlistUser;

    /**
     * Check box to switch on/off the "Messages" column in the account list.
     */
    TQCheckBox* chkAccountlistMessages;

    /**
     * Check box to switch on/off the "Size" column in the account list.
     */
    TQCheckBox* chkAccountlistSize;

    /**
     * Check box to switch on/off the "Number" column in the message list.
     */
    TQCheckBox* chkMessagelistNumber;

    /**
     * Check box to switch on/off the "Account" column in the message list.
     */
    TQCheckBox* chkMessagelistAccount;

    /**
     * Check box to switch on/off the "From" column in the message list.
     */
    TQCheckBox* chkMessagelistFrom;

    /**
     * Check box to switch on/off the "To" column in the message list.
     */
    TQCheckBox* chkMessagelistTo;

    /**
     * Check box to switch on/off the "Subject" column in the message list.
     */
    TQCheckBox* chkMessagelistSubject;

    /**
     * Check box to switch on/off the "Date" column in the message list.
     */
    TQCheckBox* chkMessagelistDate;

    /**
     * Check box to switch on/off the "Size" column in the message list.
     */
    TQCheckBox* chkMessagelistSize;

    /**
     * Check box to switch on/off the "Content" column in the message list.
     */
    TQCheckBox* chkMessagelistContent;

    /**
     * Check box to switch on/off the "State" column in the message list.
     */
    TQCheckBox* chkMessagelistState;

    /**
     * Check box to switch on/off HTML in the message view.
     */
    TQCheckBox* chkAllowHTML;

  public slots:

    /**
     * Connected with the configuration items.
     * Calls the slot changed() of TDECModule to notify the dialog about the change.
     */
    void slotChanged();
};

#endif
