/***************************************************************************
                          ProgressDialog.h  -  description
                             -------------------
    begin                : Die Mai 15 15:34:19 CEST 2001
    copyright            : (C) 2001 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PROGRESSDIALOG_H
#define PROGRESSDIALOG_H

#include <tqwidget.h>
#include <kurl.h>

struct RenamedList
{
    KURL src;
    KURL dst;
        
    bool dir;    
    bool error;
};

class KRenameImpl;
class TDEListView;
class TDEPopupMenu;
class KPushButton;
class TQProgressBar;
class TQStringList;
class TQStrList;
class TQString;
class TQTimer;
class TQHBoxLayout;
class TQVBoxLayout;
class ProgressDialog : public TQWidget
{ 
    Q_OBJECT
  
    public:
        ProgressDialog( TQWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
        ~ProgressDialog();

        void setProgressTotalSteps( int t );
        void setProgress( int p );

        inline bool wasCancelled() const;
        inline void setDestination( const KURL & dir );
        inline void setRenamedFiles( RenamedList* list, unsigned int size ) ;
        inline void setCreatedDirectories( const KURL::List & list );

        void done( int errors, int successfull, bool allowundo );
        void print( TQString text, TQString pixmap = 0 );
        void error( TQString text );
        void warning( TQString text );
        
    public slots:
        void show();
        
    private slots:
        void quitAll();
        void restart();
        void again();
        void unAgain();
        void allAgain();
        void openDest();
        void canceled();
        void undo();
        void slotTimer();
        
    private:
        TQString count();
        const TQString simplify( const TQString & text );
        
    protected:
        RenamedList* renamedFiles;
        unsigned int m_size;
        
        KURL m_dest;
        int m_count;
        bool m_canceled;
        KURL::List m_created;
        
        TQTimer* m_timer;
        
        TDEListView* display;
        KPushButton* buttonClose;
        KPushButton* buttonRestart;
        KPushButton* buttonOpenDest;
        KPushButton* buttonUndo;
        KPushButton* buttonCancel;
        TDEPopupMenu* mnuButton;

        TQProgressBar* bar;

        TQVBoxLayout* ProgressDialogLayout;
        TQHBoxLayout* Layout1;
};


bool ProgressDialog::wasCancelled() const
{ 
    return m_canceled;
}

void ProgressDialog::setDestination( const KURL & dir ) 
{
    m_dest = dir;
}

void ProgressDialog::setRenamedFiles( RenamedList* list, unsigned int size ) 
{
    renamedFiles = list;
    m_size = size;
}
        
void ProgressDialog::setCreatedDirectories( const KURL::List & list ) 
{
    m_created = list;
}

#endif // PROGRESSDIALOG_H
