/***************************************************************************
                          krenameimpl.h  -  description
                             -------------------
    begin                : Die Mai 20 2003
    copyright            : (C) 2003 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KRENAMEIMPL_H
#define KRENAMEIMPL_H

// Own includes
#include "batchrenamer.h"
#include "krenamedcop.h"

class HelpDialog;
class HelpDialogData;
class TDEAction;
class KComboBox;
class KJanusWidget;
class KMyHistoryCombo;
class KMyListBox;
class KMyListView;
class KMenuBar;
class TDEPopupMenu;
class KPushButton;
class TDEToggleAction;
class KURL;
class KURLRequester;
class KIntNumInput;
class MyHelpCombo;
class MyLabel;
class Plugin;
class PluginLoader;
class TQButtonGroup;
class TQCheckBox;
class TQGroupBox;
class TQFileInfo;
class TQFrame;
class TQHBoxLayout;
class TQLabel;
class TQLineEdit;
class TQListView;
class TQPushButton;
class TQRect;
class TQWidgetStack;
class TQRadioButton;
class TQVBoxLayout;
class TQVGroupBox;
class TQWidget;

#include <kguiitem.h>
KPushButton* createButton( KGuiItem item, TQWidget* parent );

class KRenameImpl : public TQObject, public KRenameDCOP {
    Q_OBJECT
  
    
    friend class ProfileManager;
    friend class ProfileDlg;
    friend class tabs;

    public: 
        KRenameImpl( TQWidget* p, KMenuBar* m, TQPushButton* finish );
        ~KRenameImpl();

        void setWizardMode( bool mode );
        
        /*
         * public because both get called from KRenameImpl::launch()
         */
        void updatePre();
        void addFileOrDir( const KURL & name );

        void setup( bool wizardmode );
        void changeParent( TQWidget* p, KMenuBar* m, TQPushButton* finish, TQRect r );
        static TQWidget* launch( TQRect rect, const KURL::List & list, KRenameImpl* impl = 0, bool loadprofile = true );

        /** DCOP functions we have to implement
          */
        void addFileOrDir( const TQString & name );
        const TQString fileNameTemplate() const;
        inline int counterStart() const;
  
        void setExtensionTemplate( const TQString & t );
        const TQString extensionTemplate() const;

        void setUseExtension( bool b );
        bool useExtension() const;
        
        TQStringList tokens() const;

        TQString parseString( const TQString & token, const TQString & string );
        void addDir( const TQString & name, const TQString & filter, bool recursive, bool hidden, bool dirnames );

        const TQString title( int index ) const;
        
        /** @returns true if the user has specified a profile on the commandline
         *           other wise false is returned
         */
        inline bool hasCommandlineProfile() const;

    public slots:
        void setFileNameTemplate( const TQString & t );
        void setCounterStart( int index );
                
    signals:
        void pageDone( TQWidget* page, const TQString & title );
        void showPage( int page );
        void enableFinish( bool b );

    private slots:
        void about();
        void addFile();
        bool checkErrors();
        void clearList();
        void enableControls();
        void toggleImagePreview();
        void moveUp();
        void moveDown();
        void help();
        void removeFile();
        void removeFile( int index );
        void preferences();
        void replace();
        void saveConfig();
        void start();
        void updateCount();
        void undo();
        void changeUndoScriptName();
        void pluginHelpChanged();
        void getCoordinates();
        void changeNumbers();
        void updateDots();
        void updatePreview();
        void showTokenHelp();
        void toggleName();
        void changed();
        void loadFilePlugins();
        void reloadFilePluginData();
        void manageProfiles();
        TQString easyOptions( KComboBox* combo, KMyHistoryCombo* custom );
        void slotEasy1();
        void slotEasy2();
        void slotEasy3();
        void slotEasy4();

        /** Update the preview only if the passed
         *  plugin is enabled for use.
         */
        void updatePluginPreview( Plugin* p );

    private:
        static int numRealTimePreview;

        /** Change the GUI mode according to the current setting of m_wizard
          */
        void changeGUIMode();
        
        /** Returns COPY if optionCopy is checked, RENAME if optionRename is checked
          * ...
          */
        int currentRenameMode();
        
        void loadConfig();
        void fillStructures( BatchRenamer* b, bool preview );
        bool setupBatchRenamer( BatchRenamer* b, bool preview );
        void splitFilename( TQFileInfo* fi, TQString* base, TQString* extension );

        void setupActions();
        void setupPage1();
        void setupPage2();
        void setupPage3();
        void setupPage4();
        void setupTab1();
        void setupFileTab1();
        void setupFileTab2();
        void setupPages();
        void updateHist();
        void parseCommandline();
        void addTitle( TQWidget* p, TQVBoxLayout* layout, TQString title );

        TQValueList<manualchanges> changes;
        void refreshColumnMode();
        void parseWizardMode();
        void getHelpDialogString( TQLineEdit* edit );
        
    protected:
        TQWidget* parent;
        KMenuBar* menuBar;
        TDEPopupMenu* mnuSort;
        TDEAction* loadPlugins;
        
        TQPushButton* finishButton;

        PluginLoader* plugin;

        TQWidgetStack* fileTab;
        
        TQWidget* page_1;
        TQWidget* page_2;
        KJanusWidget* page_3;
        TQWidget* page_4;

        bool m_wizard;
        bool m_loadplugins;
        bool m_switching;
        bool m_autosize;
        int m_hist;
        int m_index;
        int m_step;
	bool m_reset;

        bool m_hasCommandlineProfile;

        KPushButton* buttonUp;
        KPushButton* buttonDown;
        KPushButton* buttonUp2;
        KPushButton* buttonDown2;
        KPushButton* buttonAdd;
        KPushButton* buttonRemove;
        KPushButton* buttonRemoveAll;
        KPushButton* buttonReplace;
        KPushButton* buttonEasyReplace;
        KPushButton* buttonHelp;
        KPushButton* buttonMove;
        KPushButton* buttonCoord;
        KPushButton* buttonNumber;
        
        KPushButton* buttonEasy1;
        KPushButton* buttonEasy2;
        KPushButton* buttonEasy3;
        KPushButton* buttonEasy4;
        KComboBox* comboSort;
        
        TQLabel* description;
        TQLabel* description2;
        TQLabel* description3;
        TQLabel* description4;

        TQLabel* labelTemplate;
        TQLabel* labelHelp;
        TQLabel* labelCount;
        TQLabel* labelPoint;

        KMyListBox* fileList;
        KMyListView* preview;
        TQButtonGroup* groupOptions;

        TQRadioButton* optionCopy;
        TQRadioButton* optionMove;
        TQRadioButton* optionRename;
        TQRadioButton* optionLink;

        TQGroupBox* groupExtension;
        TQVGroupBox* groupUndo;

        KMyHistoryCombo* dirname;
        KURLRequester* urlrequester;
        KURLRequester* undorequester;
        KMyHistoryCombo* filename;
        KMyHistoryCombo* extemplate;

        TQCheckBox* checkName;
        TQCheckBox* checkExtension;
        TQCheckBox* checkOverwrite;
        TQCheckBox* checkPreview;
        TQCheckBox* checkUndoScript;

        KComboBox* comboExtension;

        MyHelpCombo* comboHelp;
        HelpDialog* helpDialog;
        HelpDialogData* helpDialogData;

        BatchRenamer* b;
        TQValueList<int> skip;
        TQValueList<replacestrings> rep;

        // ==========
        // Easy mode:
        // ==========
        
        KComboBox* comboKRenamePrefix;
        KComboBox* comboKRenameSuffix;
        KComboBox* comboKRenameFilename;
        KComboBox* comboKRenameExtension;
        
        KMyHistoryCombo* comboPrefix;
        KMyHistoryCombo* comboSuffix;        
        KMyHistoryCombo* comboCustom;
        KMyHistoryCombo* comboCustomExtension;
        
        KIntNumInput* spinStart;
        KIntNumInput* spinNull;        
        
        // ===========
        // Layout:
        // ===========

        TQHBoxLayout* pageLayout;
        TQVBoxLayout* pageLayout_2;
        TQVBoxLayout* pageLayout_3;
        TQVBoxLayout* pageLayout_4;

        TQHBoxLayout* tabLayout_0;
        TQHBoxLayout* tabLayout_1;
        TQHBoxLayout* tabLayout_2;
        TQVBoxLayout* tabLayout_3;
        TQVBoxLayout* groupAdvancedExtensionLayout;
        TQVBoxLayout* groupOptionsLayout;
        TQHBoxLayout* groupDirLayout;
        TQVBoxLayout* groupNumberLayout;
        TQHBoxLayout* groupExtensionLayout;

        // page1
        TQHBoxLayout* Layout2;
        TQVBoxLayout* Layout3;
        TQHBoxLayout* Layout4;
        TQVBoxLayout* Layout5;

        // page4
        TQVBoxLayout* Layout10;
        TQHBoxLayout* Layout15;
        TQVBoxLayout* Layout16;
        TQHBoxLayout* Layout22;
        TQVBoxLayout* Layout23;

        // tab
        TQHBoxLayout* Layout100;
        TQHBoxLayout* Layout101;
};


int KRenameImpl::counterStart() const
{
    return m_index;
}

bool KRenameImpl::hasCommandlineProfile() const
{
    return m_hasCommandlineProfile;
}

#endif
