/***************************************************************************
                          pictureplugin.cpp  -  description
                             -------------------
    begin                : Son Apr 14 2002
    copyright            : (C) 2002 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "pictureplugin.h"

// QT includes
#include <tqimage.h>

// KDE includes
#include <tdeapplication.h>
#include <tdelocale.h>

PicturePlugin::PicturePlugin()
    : FilePlugin( 0 )
{
    keys.append( "resolution" );
    keys.append( "xres" );
    keys.append( "yres" );
    keys.append( "bitdepth" );   
    setupKeys();
    
    m_icon = "image-x-generic";
}

const TQString PicturePlugin::getName() const
{
    return i18n("Picture Plugin");
}

const TQString PicturePlugin::getAccelName() const
{
    return i18n("P&icture Plugin");
}

const TQString PicturePlugin::getPattern() const
{
    return "pic";
}

TQString PicturePlugin::processFile( BatchRenamer* b, int i, TQString token, int )
{
    TQString resolution;
    TQString xres;
    TQString yres;
    TQString bitdepth;
    
    TQString filename = BatchRenamer::buildFilename( &b->files()[i].src );

    token = token.lower();
       
    /*
     * Check if we have something cached for this file
     */
    if( cache.contains( filename + "::" + token ) )
        return cache[filename + "::" + token ];
    
    TQImage img( filename );
    if( img.isNull() )
        return TQString();

    resolution = TQString( "%1x%2" ).arg(img.width()).arg(img.height());
    xres = TQString::number( img.width() );
    yres = TQString::number( img.height() );
    bitdepth = TQString::number( img.depth() );

    if( cache.count() >= CACHE_MAX )
        cache.remove( cache.begin() );

    TQString ret = TQString();
    
    if( token == getPattern() + "resolution" )
        ret = resolution;
    else if( token == getPattern() + "xres" )
        ret = xres;
    else if( token == getPattern() + "yres" )
        ret = yres;
    else if( token == getPattern() + "bitdepth" )
        ret = bitdepth;

    cache.insert( filename + "::" + token, ret );    
    return ret;
}


