/***************************************************************************
                          myinputdialog.cpp  -  description
                             -------------------
    begin                : Mit Apr 01 2002
    copyright            : (C) 2002 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "myinputdialog.h"

#include <klineedit.h>
#include <kpushbutton.h>
#include <tdelocale.h>
#include <tqlabel.h>
#include <tqlayout.h>
#include <tqtooltip.h>

MyInputDialog::MyInputDialog( TQString filename, bool revertEnabled, TQWidget* parent )
    : TQDialog( parent, 0, true, 0 )
{
    // I do not think this has to be translated
    setCaption( "KRename" );

    MyInputDialogLayout = new TQVBoxLayout( this, 11, 6, "MyInputDialogLayout");
    Layout = new TQHBoxLayout( 0, 0, 6, "Layout");

    TextLabel1 = new TQLabel( this, "TextLabel1" );
    TextLabel1->setText( i18n( "Please input a new filename:" ) );

    text = new KLineEdit( this, "text" );
    text->setText( filename );

    TQSpacerItem* spacer = new TQSpacerItem( 20, 20, TQSizePolicy::Expanding, TQSizePolicy::Minimum );

    buttonKrename = new KPushButton( this, "buttonKrename" );
    buttonKrename->setText( i18n( "&Revert Changes" ) );
    buttonKrename->setEnabled( revertEnabled );

    buttonFilename = new KPushButton( this, "buttonFilename" );
    buttonFilename->setText( i18n("Use &Input Filename") );

    buttonOk = new KPushButton( this, "buttonOk" );
    buttonOk->setText( i18n( "&Ok" ) );
    buttonOk->setDefault( true );

    buttonCancel = new KPushButton( this, "buttonCancel" );
    buttonCancel->setText( i18n( "&Cancel" ) );

    text->setFocus();

    Layout->addWidget( buttonKrename );
    Layout->addWidget( buttonFilename );
    Layout->addItem( spacer );
    Layout->addWidget( buttonOk );
    Layout->addWidget( buttonCancel );

    MyInputDialogLayout->addWidget( TextLabel1 );
    MyInputDialogLayout->addWidget( text );
    MyInputDialogLayout->addLayout( Layout );

    connect( buttonCancel, TQT_SIGNAL( clicked() ), this, TQT_SLOT( reject() ) );
    connect( buttonOk, TQT_SIGNAL( clicked() ), this, TQT_SLOT( accept() ) );
    connect( buttonKrename, TQT_SIGNAL( clicked() ), this, TQT_SLOT( krename() ) );
    connect( buttonFilename, TQT_SIGNAL( clicked() ), this, TQT_SLOT( slotFilename() ) );

    TQToolTip::add( buttonKrename, i18n("Use the filename that is generated by "
                                       "KRename instead of your changes." ) );
}

MyInputDialog::~MyInputDialog()
{ }

 TQString MyInputDialog::filename() const
{
    return text->text();
}

void MyInputDialog::accept()
{
    if( text->text().isEmpty() )
        reject();
    else
        done( OK );
}

void MyInputDialog::reject()
{
    done( CANCEL );
}

void MyInputDialog::krename()
{
    done( USE_KRENAME );
}

void MyInputDialog::slotFilename()
{
    text->setText( m_oldfilename );
}

