/***************************************************************************
                          coorddialog.cpp  -  description
                             -------------------
    begin                : Die Feb 4 2003
    copyright            : (C) 2003 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "coorddialog.h"

// TQt includes
#include <tqcheckbox.h>
#include <tqfontmetrics.h>
#include <tqlabel.h>
#include <tqlayout.h>
#include <tqvalidator.h>

// KDE includes
#include <tdeapplication.h>                                                                  
#include <tdelocale.h>

DSLineEdit::DSLineEdit( TQWidget* parent, const char* name )
    : KLineEdit( parent, name )
{
}

void DSLineEdit::keyPressEvent( TQKeyEvent* e )
{
    KLineEdit::keyPressEvent( e );
    emit changed();
}

void DSLineEdit::mousePressEvent( TQMouseEvent* e )
{
    KLineEdit::mousePressEvent( e );
    emit changed();
}

bool CoordDialog::m_inversion = false;

CoordDialog::CoordDialog( const TQString & file, TQWidget *_parent, const char *name )
    : KDialogBase( KDialogBase::Plain, "KRename",
      KDialogBase::Ok | KDialogBase::Cancel, KDialogBase::Ok, _parent, name, true, true ), m_file( file )
{
    TQFrame* parent = plainPage();
    TQVBoxLayout* layout = new TQVBoxLayout( parent );

    filename = new DSLineEdit( parent );
    filename->setText( file );
    filename->setValidator( new TQRegExpValidator( TQRegExp( file ), TQT_TQOBJECT(this) ) );
    
    preview = new TQLabel( parent );

    checkInvert = new TQCheckBox( i18n("&Invert selection"), plainPage() );
    checkInvert->setChecked( m_inversion );
    
    layout->addWidget( new TQLabel( i18n("Please select the text you want to insert:"), plainPage() ) );
    layout->addWidget( filename );
    layout->addWidget( checkInvert );
    layout->addWidget( preview );

    updateCommand();
    connect( filename, TQT_SIGNAL( selectionChanged() ), this, TQT_SLOT( updateCommand() ) );
    connect( checkInvert, TQT_SIGNAL( clicked() ), this, TQT_SLOT( updateCommand() ) );
    connect( filename, TQT_SIGNAL( textChanged( const TQString & ) ), this, TQT_SLOT( resetText() ) );
    connect( filename, TQT_SIGNAL( changed() ), this, TQT_SLOT( updateCommand() ) );

    show();
    
    TQFontMetrics fm( filename->font() );
    int w = fm.width( file );
    if( w > width() )
        resize(
            ( w < TDEApplication::desktop()->width() - 40 ? w + 40 : TDEApplication::desktop()->width() ), height() );
}

CoordDialog::~CoordDialog()
{
}

void CoordDialog::updateCommand()
{
    int start = 0;
    int end = 0;
    m_command = "";    

    (void)filename->getSelection( &start, &end );

    if( !filename->text().isEmpty() ) {
       if( checkInvert->isChecked() && filename->hasSelectedText() ) {
            // inverted
            if( end ) {
                start++;
                end++;
                if( start > 1 )
                    m_command = TQString("[$1;%1]").arg(start-1);

                if( end <= (signed int)filename->text().length() )
                    m_command.append( TQString("[$%1-[length]]").arg(end) );
            } 
        } else if( checkInvert->isChecked() && !filename->hasSelectedText() ) {
            int p = filename->cursorPosition();
            m_command = TQString("[$1;%1][$%2-[length]]").arg(p).arg(p+1);            
        } else if( !checkInvert->isChecked() && filename->hasSelectedText() ){
            if( end ) {
                start++;
                end++;
                if( end <= (signed int)filename->text().length() )
                    m_command = TQString("[$%1;%2]").arg(start).arg(end-start);
                else
                    m_command = TQString("[$%1-[length]]").arg(start);
            }
        } else if( !checkInvert->isChecked() && !filename->hasSelectedText() ) {
            int p = filename->cursorPosition();
            m_command = TQString("[$%1-[length]]").arg( p );
        }

    }
    
    preview->setText( i18n("Preview: ") + m_command );
}

void CoordDialog::resetText()
{
    filename->setText( m_file );
    updateCommand();
}

TQString CoordDialog::coords()
{
    m_inversion = checkInvert->isChecked();
    return m_command;
}
