/***************************************************************************
                          commandplugin.cpp  -  description
                             -------------------
    begin                : Son Jan 5 2003
    copyright            : (C) 2003 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "commandplugin.h"

// QT includes
#include <tqcheckbox.h>
#include <tqlabel.h>
#include <tqlayout.h>

// KDE includes
#include <tdeapplication.h>
#include <tdeconfig.h>
#include <kiconloader.h>
#include <tdelocale.h>
#include <klineedit.h>
#include <tdelistbox.h>
#include <tdemessagebox.h>
#include <kpushbutton.h>
#include <kprocess.h>

const TQString CommandPlugin::getName() const
{
    return i18n("Command Plugin");
}

const TQString CommandPlugin::getAccelName() const
{
    return i18n("&Command Plugin");
}

const int CommandPlugin::type() const
{
    return TYPE_FINAL_FILE;
}

bool CommandPlugin::checkError()
{
    if( commandline->text().isEmpty() ) {
        KMessageBox::error( 0, i18n("You did not specify a command to execute.") );
        return false;
    }

    return true;
}

void CommandPlugin::drawInterface( TQWidget* w, TQVBoxLayout* l )
{
    m_widget = w;

    TQHBoxLayout* hb = new TQHBoxLayout( 0, 0, 6 );
    TQVBoxLayout* vb = new TQVBoxLayout( 0, 0, 6 );

    TQLabel* la = new TQLabel( w );
    la->setText( i18n("<b>Command Plugin</b>") );
    l->addWidget( la );

    la = new TQLabel( w );
    la->setText( i18n( "<qt>Executes a shell command on every file after it has been renamed. "
                       "Add %1 to the command line arguments to get the filename of the renamed file.</qt>") );
    l->addWidget( la );
    l->addWidget( new TQLabel( i18n("Command:"), w ) );

    commandline = new KLineEdit( w );
    l->addWidget( commandline );

    checkNoBlock = new TQCheckBox( i18n("&Execute without blocking (not recommended)"), w );
    l->addWidget( checkNoBlock );

    buttonAdd = new KPushButton( i18n("&Add"), w );
    buttonRemove = new KPushButton( i18n("&Remove"), w );
    hb->addWidget( buttonAdd );
    hb->addWidget( buttonRemove );

    vb->addLayout( hb );

    list = new TDEListBox( w );
    vb->addWidget( list );
    vb->setStretchFactor( list, 2 );
    l->addLayout( vb );

    connect( buttonAdd, TQT_SIGNAL( clicked() ), this, TQT_SLOT( add() ) );
    connect( buttonRemove, TQT_SIGNAL( clicked() ), this, TQT_SLOT( remove() ) );
    connect( list, TQT_SIGNAL( executed( TQListBoxItem* ) ), this, TQT_SLOT( exec() ) );

    TDEConfig* conf = kapp->config();
    conf->setGroup("CommandPlugin");
    list->insertStringList( conf->readListEntry("commandlines" ) );
    
    TQStringList examples;
    examples.append( "chmod 0444 %1" );
    examples.append( "convert %1 %1.png" );
    examples.append( "echo %1 >> $HOME/file.list" );
//    examples.append( ")    
    for( unsigned int i = 0; i < examples.count(); i++ )
        if( !list->findItem( examples[i] ) )
            list->insertItem( examples[i] );
}

void CommandPlugin::fillStructure()
{
    command = commandline->text();
    noblock = checkNoBlock->isChecked();
}

TQString CommandPlugin::processFile( BatchRenamer* b, int i, TQString, int )
{
    TQString filename = b->files()[i].dst.name;
    

    TQString c = command;
       
    KShellProcess proc;
    c = c.replace( "%1", KShellProcess::quote( filename ) );

    proc << c;
    
    if( noblock )
        proc.start( TDEProcess::DontCare, TDEProcess::NoCommunication );
    else
        proc.start( TDEProcess::Block, TDEProcess::NoCommunication );

    proc.resume();

    if( !noblock && proc.exitStatus() )
        return command.arg( filename ) + TQString( i18n(" exited with error: %1") ).arg( proc.exitStatus() );

    return TQString();
}

void CommandPlugin::finished()
{
    TDEConfig* conf = kapp->config();
    conf->setGroup("CommandPlugin");
    TQStringList slist;
    for( unsigned int i = 0; i < list->count(); i++ )
        slist.append( list->text( i ) );

    conf->writeEntry("commandlines", slist );
    conf->sync();
    return;
}

void CommandPlugin::add()
{
    if( !commandline->text().isEmpty() ) {
        for( unsigned int i = 0; i < list->count(); i++ )
            if( list->text( i ) == commandline->text() )
                return;

        list->insertItem( commandline->text() );
    }
}

void CommandPlugin::remove()
{
    unsigned int i = 0;
    do {
        if(list->isSelected( i ))
            list->removeItem( i );
        else
            i++;
    } while( i < list->count() );
}

void CommandPlugin::exec()
{
    for( unsigned int i = 0; i < list->count(); i++ )
        if( list->isSelected( i ) )
            commandline->setText( list->text( i ) );
}

const TQPixmap CommandPlugin::getIcon() const
{
    return kapp->iconLoader()->loadIcon( "konsole", TDEIcon::Small );
}

