/***************************************************************************
                          krecursivelister.cpp  -  description
                             -------------------
    begin                : Fri Aug 31 2001
    copyright            : (C) 2001 by Jonathon Sim
    email                : jonathonsim@iname.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <tqtimer.h>

#include "krecursivelister.h"

KRecursiveLister::KRecursiveLister(TQObject *parent, const char *name ) : TQObject(parent,name) {
    lister = 0L;
    filelist.clear();
    dirlist.clear();
    dirtree.clear();
    allItems.setAutoDelete( true ); // only there to delete all items
    m_hidden = false;
    m_dirs = false;
    m_filter = TQString();
}

KRecursiveLister::~KRecursiveLister(){
    delete lister;
}

void KRecursiveLister::cleanUp()
{
    filelist.clear();
    dirlist.clear();
}
/** Starts listing the specified url */
void KRecursiveLister::openURL(const KURL& url ){
    filelist.clear();
    dirlist.clear();
    startListing(url);
}

/** Returns the list of fileitems found. */
const KFileItemList & KRecursiveLister::items(){
    return filelist;
}

/** handles completion of a listing. */
void KRecursiveLister::slotListingComplete(){
    KFileItemList templist=lister->items();

    KFileItem * item;
    KFileItem * newitem;
    for( item = templist.first(); item != 0; item=templist.next() )
    {
        if (item->isDir()) {
            newitem= new KFileItem(*item);
            dirlist.append(newitem);//Used for recursing the directories
            dirtree.append(newitem);//Returned to user on request.
            allItems.append(newitem);
        }
        else {
            newitem= new KFileItem(*item);
            filelist.append(newitem);
            allItems.append(newitem);
        }
    }

    TQTimer::singleShot( 0, this, TQT_SLOT( listNextDirectory() ));
}

/** Starts listing the specified url */
void KRecursiveLister::startListing(const KURL& url){
    if (!lister) {
        lister=new KDirLister(true);
        lister->setShowingDotFiles( m_hidden );
        lister->setNameFilter( m_filter );
        lister->setDirOnlyMode( m_dirs );
        connect(lister,TQT_SIGNAL(completed()), this, TQT_SLOT(slotListingComplete()) );
    }

    lister->openURL( url, false, false );
}

void KRecursiveLister::listNextDirectory()
{
    if ( dirlist.isEmpty() )
        emit completed();
    else
    {
        KFileItem * nextdir=dirlist.last();
        KURL url = nextdir->url();
        dirlist.removeLast();
        startListing( url );
    }
}

/** Stops the listing */
void KRecursiveLister::stop(){
    lister->stop();
}

/** Returns the subdirectories found by the listing */
const KFileItemList& KRecursiveLister::dirs(){
    return dirtree;
}
#include "krecursivelister.moc"
