/***************************************************************************
                          coorddialog.h  -  description
                             -------------------
    begin                : Die Feb 4 2003
    copyright            : (C) 2003 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef COORDDIALOG_H
#define COORDDIALOG_H

#include <kdialogbase.h>
#include <klineedit.h>

class TQKeyEvent;
class DSLineEdit : public KLineEdit {
    Q_OBJECT
  
    public:
        DSLineEdit( TQWidget* parent = 0, const char* name = 0 );

    signals:
        void changed();
        
    protected:
        void keyPressEvent( TQKeyEvent* e );
        void mousePressEvent( TQMouseEvent* e );
};

class TQCheckBox;
class TQLabel;
class TQString;

/* The name of this class was a very bad choice.
 * CoordDialog is an abreviation vor Coordinate Dialog,
 * because this dialog is ought to be for selecting
 * the coordinates of a filename using an [x;y] token.
 */
class CoordDialog : public KDialogBase  {
    Q_OBJECT
  
    public: 
        CoordDialog( const TQString & file, TQWidget *_parent=0, const char *name=0);
        ~CoordDialog();

        TQString coords();

        static bool m_inversion;
                
    private slots:
        void updateCommand();
        void resetText();
        
    private:
        TQString m_file;
        TQString m_command;

        DSLineEdit* filename;
        TQCheckBox* checkInvert;
        TQLabel* preview;
};

#endif
