/***************************************************************************
                          kmylistview.cpp  -  description
                             -------------------
    begin                : Mit M� 27 2002
    copyright            : (C) 2002 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kmylistview.h"
#include "myinputdialog.h"

// KDE includes
#include <kiconloader.h>
#include <tdelocale.h>
#include <tdepopupmenu.h>
#include <krun.h>

KMyListView::KMyListView( TQValueList<manualchanges>* _changes, KMyListBox* _list, TQWidget* parent, const char* name )
    :TDEListView(parent, name )
{
    changes = _changes;
    list = _list;

    connect( this, TQT_SIGNAL( doubleClicked(TQListViewItem*, const TQPoint&, int) ),
        this, TQT_SLOT( changeItem(TQListViewItem*, const TQPoint&, int) ) );
    connect( this, TQT_SIGNAL( contextMenuRequested(TQListViewItem*, const TQPoint&, int) ),
        this, TQT_SLOT( showContext(TQListViewItem*, const TQPoint&, int) ) );
    setAllColumnsShowFocus( true );
}

KMyListView::~KMyListView()
{ }


void KMyListView::changeItem( TQListViewItem* item, const TQPoint&, int )
{
    if(!item) return;

    KURL url = list->url( itemIndex( item ) );

    bool revertenable = false;
    TQValueList<manualchanges>::iterator it;
    for ( it = changes->begin(); it != changes->end(); ++it )
        if( (*it).url == url ) {
            changes->remove( it );
            revertenable = true;
            break;
        }


    MyInputDialog i( item->text( 1 ), revertenable );
    i.setInputFilename( item->text( 0 ) );

    int code = i.exec();
    if( code == MyInputDialog::OK ) {
        manualchanges tmp = {
            url,
            i.filename()
        };

        changes->append( tmp );
        emit itemChanged();
    } else if( code == MyInputDialog::USE_KRENAME )
        emit itemChanged();
}

void KMyListView::showContext( TQListViewItem* item, const TQPoint& pos, int )
{
    TDEPopupMenu* menu = new TDEPopupMenu( this );
    if(item) {
        menu->insertTitle( list->text( itemIndex( item ) ), 0, 0 );
        menu->insertItem( i18n("&Change Filename Manually"), this, TQT_SLOT( changeCurrentItem() ), Key_F2 );
        menu->insertSeparator();
        menu->insertItem( BarIcon("application-x-executable"), i18n("Open"), this, TQT_SLOT( openCurrent() ) );
        menu->insertSeparator();
    }
    menu->insertItem( BarIcon("document-open"), i18n("&Add..."), this, TQT_SLOT( addFiles() ) );
    if(item)
        menu->insertItem( BarIcon("edit-delete"), i18n("&Remove"), this, TQT_SLOT( removeCurrentItem() ) );
            
    menu->popup( pos );
}

void KMyListView::removeCurrentItem()
{
    int index = itemIndex( currentItem() );
    emit removeItem( index );    
}

void KMyListView::addFiles()
{
    emit addFile();
}

void KMyListView::changeCurrentItem()
{
    changeItem( currentItem(), TQPoint( 0, 0 ), 0 );
}

void KMyListView::openCurrent()
{
    if( currentItem() )
        new KRun( list->text( itemIndex( currentItem() ) ) );
}

/////////////////////////////////////////////////////////////

KMyListViewItem::KMyListViewItem(TQListView *parent)
  : TDEListViewItem(parent)
{ }

KMyListViewItem::KMyListViewItem(TQListViewItem *parent)
  : TDEListViewItem(parent)
{ }

KMyListViewItem::KMyListViewItem(TQListView *parent, TQListViewItem *after)
  : TDEListViewItem(parent, after)
{ }

KMyListViewItem::KMyListViewItem(TQListViewItem *parent, TQListViewItem *after)
  : TDEListViewItem(parent, after)
{ }

KMyListViewItem::KMyListViewItem(bool m, TQListView *parent,
    TQString label1, TQString label2, TQString label3, TQString label4,
    TQString label5, TQString label6, TQString label7, TQString label8)
  : TDEListViewItem(parent, label1, label2, label3, label4, label5, label6, label7, label8)
{
    modified = m;
}

KMyListViewItem::KMyListViewItem(bool m, TQListViewItem *parent,
    TQString label1, TQString label2, TQString label3, TQString label4,
    TQString label5, TQString label6, TQString label7, TQString label8)
  : TDEListViewItem(parent, label1, label2, label3, label4, label5, label6, label7, label8)
{
    modified = m;
}

KMyListViewItem::KMyListViewItem(bool m, TQListView *parent, TQListViewItem *after,
    TQString label1, TQString label2, TQString label3, TQString label4,
    TQString label5, TQString label6, TQString label7, TQString label8)
  : TDEListViewItem(parent, after, label1, label2, label3, label4, label5, label6, label7, label8)
{
    modified = m;
}

KMyListViewItem::KMyListViewItem(TQListViewItem *parent, TQListViewItem *after,
    TQString label1, TQString label2, TQString label3, TQString label4,
    TQString label5, TQString label6, TQString label7, TQString label8)
  : TDEListViewItem(parent, after, label1, label2, label3, label4, label5, label6, label7, label8)
{ }

KMyListViewItem::~KMyListViewItem()
{ }

void KMyListViewItem::paintCell( TQPainter *p, const TQColorGroup &cg,
                                int column, int width, int alignment )
{
    TQColorGroup _cg( cg );
    TQColor c = _cg.text();
    if( modified )
        _cg.setColor( TQColorGroup::Text, TQt::red );

    TDEListViewItem::paintCell( p, _cg, column, width, alignment );
    _cg.setColor( TQColorGroup::Text, c );
}

#include "kmylistview.moc"
