/***************************************************************************
*   Copyright (C) 2003 by                                                 *
*   Jason Kivlighn (jkivlighn@gmail.com)                                  *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef MXPIMPORTER_H
#define MXPIMPORTER_H

#include <ntqstring.h>

#include "baseimporter.h"

/** Class to import MasterCook's MXP (MasterCook Export) file format.
  * This is a human-readable format used in Mastercook up until version 4.
  * @author Jason Kivlighn
  */
class MXPImporter : public BaseImporter
{
public:
	MXPImporter();
	virtual ~MXPImporter();

protected:
	void parseFile( const TQString& filename );

private:
	void importMXP( TQTextStream &stream );

	void loadCategories( TQTextStream &stream, Recipe &recipe );
	void loadIngredients( TQTextStream &stream, Recipe &recipe );
	void loadInstructions( TQTextStream &stream, Recipe &recipe );
	void loadOptionalFields( TQTextStream &stream, Recipe &recipe );

	void importMac( TQTextStream &stream );
	void importGeneric( TQTextStream &stream );

	TQString getNextQuotedString( TQTextStream &stream );
};

#endif //MXPIMPORTER_H
