/***************************************************************************
*   Copyright (C) 2003 by                                                 *
*   Unai Garro (ugarro@users.sourceforge.net)                             *
*   Cyril Bosselut (bosselut@b1project.com)                               *
*   Jason Kivlighn (jkivlighn@gmail.com)                                  *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef SELECTPROPERTYDIALOG_H
#define SELECTPROPERTYDIALOG_H

#include <ntqwidget.h>
#include <ntqlayout.h>
#include <ntqgroupbox.h>
#include <ntqlabel.h>
#include <ntqpushbutton.h>
#include <ntqvbox.h>

#include <tdelistview.h>
#include <kcombobox.h>
#include <kdialogbase.h>

#include "datablocks/unit.h"

class IngredientPropertyList;

/**
@author Unai Garro
*/
class SelectPropertyDialog: public KDialogBase
{
public:
	typedef enum OptionFlag { ShowEmptyUnit, HideEmptyUnit } ;

	// Methods
	SelectPropertyDialog( TQWidget* parent, IngredientPropertyList *propertyList, UnitList *unitList, OptionFlag showEmpty = ShowEmptyUnit );
	~SelectPropertyDialog();
	int propertyID( void );
	int perUnitsID( void );
private:
	//Widgets
	TQGroupBox *box;
	TDEListView *propertyChooseView;
	TQLabel *perUnitsLabel;
	KComboBox *perUnitsBox;
	OptionFlag m_showEmpty;

	void loadProperties( IngredientPropertyList *propertyList );
	void loadUnits( UnitList *unitList );

	//Internal variables
	UnitList *unitListBack; // To store unit list with ID's for later use

};

#endif
