/***************************************************************************
*   Copyright (C) 2003 by                                                 *
*   Unai Garro <ugarro@users.sourceforge.net>                             *
*   Cyril Bosselut (bosselut@b1project.com)                               *
*   Jason Kivlighn (jkivlighn@gmail.com)                                  *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef KRECIPESVIEW_H
#define KRECIPESVIEW_H

#include <ntqbitmap.h>
#include <ntqbuttongroup.h>
#include <ntqevent.h>
#include <ntqlabel.h>
#include <ntqpushbutton.h>
#include <ntqtooltip.h>
#include <ntqhbox.h>
#include <ntqvaluelist.h>
#include <ntqvbox.h>
#include <ntqwidget.h>
#include <ntqwidgetstack.h>

#include <kiconloader.h>
#include <kpixmap.h>
#include <kpixmapeffect.h>
#include <kimageeffect.h>
#include <tdeparts/part.h>
#include <tdestyle.h>
#include <ktextbrowser.h>

#include "importers/baseimporter.h"
#include "backends/recipedb.h"
#include "krecipesiface.h"

class AuthorsDialog;
class PrepMethodsDialog;
class CategoriesEditorDialog;
class DietWizardDialog;
class IngredientsDialog;
class Menu;
class KreMenu;
class KreMenuButton;
class IngredientMatcherDialog;
class PanelDeco;
class PropertiesDialog;
class TQPainter;
class RecipeInputDialog;
class RecipeViewDialog;
class SelectRecipeDialog;
class ShoppingListDialog;
class UnitsDialog;
typedef TQValueList <Menu>::Iterator MenuId;


/**
 * This is the main view class for Krecipes.  Most of the non-menu,
 * non-toolbar, and non-statusbar (e.g., non frame) GUI code should go
 * here.
 *
 * This krecipes uses an HTML component as an example.
 *
 * @short Main view
 * @author Unai Garro <ugarro@users.sourceforge.net>
 * @version 0.4
 */


// Declarations



// Some constants
typedef enum KrePanel {SelectP = 0, ShoppingP, DietP, MatcherP, IngredientsP, PropertiesP, UnitsP, PrepMethodsP, CategoriesP, AuthorsP, RecipeEdit, RecipeView };


// Class KrecipesView
class KrecipesView : public TQVBox, virtual public KrecipesIface
{
	Q_OBJECT
public:
	/**
	 * Default constructor
	 */
	KrecipesView( TQWidget *parent );

	/**
	 * Destructor
	 */
	virtual ~KrecipesView();

	virtual DCOPRef currentDatabase() const;
	RecipeDB *database;

	/**
	 * Print this view to any medium -- paper or not
	 */
	void print();

	virtual void show ( void ); //Needed to make sure that the raise() is done after the construction of all the widgets, otherwise childEvent in the PanelDeco is called only _after_ the raise(), and can't be shown.

signals:
	/**
	 * Use this signal to change the content of the statusbar
	 */
	void signalChangeStatusbar( const TQString& text );

	/**
	 * Use this signal to change the content of the caption
	 */
	void signalChangeCaption( const TQString& text );

	void panelShown( KrePanel, bool );


public:

	// public widgets
	RecipeInputDialog *inputPanel;
	RecipeViewDialog *viewPanel;
	SelectRecipeDialog *selectPanel;
	IngredientsDialog *ingredientsPanel;
	PropertiesDialog *propertiesPanel;
	UnitsDialog* unitsPanel;
	ShoppingListDialog* shoppingListPanel;
	DietWizardDialog* dietPanel;
	CategoriesEditorDialog *categoriesPanel;
	AuthorsDialog *authorsPanel;
	PrepMethodsDialog *prepMethodsPanel;
	IngredientMatcherDialog *ingredientMatcherPanel;

	// public methods
	void createNewRecipe( void );
	void createNewElement( void );

	void exportRecipes( const TQValueList<int> &ids );

private:

	// Internal methods
	TQString checkCorrectDBType( TDEConfig *config );
	void initializeData( const TQString &host, const TQString &dbName, const TQString &user, const TQString &pass, int port );
	void initDatabase( TDEConfig *config );
	bool questionRerunWizard( const TQString &message, const TQString &error = "" );
	void setupUserPermissions( const TQString &host, const TQString &client, const TQString &dbName, const TQString &newUser, const TQString &newPass, const TQString &adminUser = TQString::null, const TQString &adminPass = TQString::null, int port = 0 );
	void wizard( bool force = false );



	// Widgets
	TQHBox *splitter;
	KreMenu *leftPanel;
	MenuId dataMenu;
	PanelDeco *rightPanel;
	TQPtrList<KreMenuButton> *buttonsList;
	KreMenuButton *button0;
	KreMenuButton *button1;
	KreMenuButton *button2;
	KreMenuButton *button3;
	KreMenuButton *button4;
	KreMenuButton *button5;
	KreMenuButton *button6;
	KreMenuButton *button7;
	KreMenuButton *button8;
	KreMenuButton *button9;
	TQPushButton* contextButton;

	KreMenuButton *recipeButton;
	TQWidget *recipeWidget;

	// Internal variables
	TQString dbType;
	KrePanel m_activePanel;

	TQMap<TQWidget*, KrePanel> panelMap;

	// i18n
	void translate();


signals:
	void enableSaveOption( bool en );
	void recipeSelected( bool );

public slots:
	bool save( void );
	void exportRecipe();
	void exportToClipboard();
	void reloadDisplay();
	virtual void reload();
	void activateContextHelp();

private slots:
	void actionRecipe( int recipeID, int action );
	void actionRecipes( const TQValueList<int> &ids, int action );
	void addRecipeButton( TQWidget *w, const TQString &title );
	void closeRecipe( void );
	void showRecipe( int recipeID );
	void showRecipes( const TQValueList<int> &recipeIDs );
	void slotSetTitle( const TQString& title );
	void slotSetPanel( KrePanel );
	void switchToRecipe( void );
	void createShoppingListFromDiet( void );
	void moveTipButton( int, int );
	void resizeRightPane( int lpw, int lph );
	void panelRaised( TQWidget *w, TQWidget *old_w );
	void editRecipe();
};


#endif // KRECIPESVIEW_H
