/***************************************************************************
*   Copyright (C) 2003 by                                                 *
*   Unai Garro (ugarro@users.sourceforge.net)                             *
*   Cyril Bosselut (bosselut@b1project.com)                               *
*   Jason Kivlighn (jkivlighn@gmail.com)                                  *
*                                                                         *
*   Copyright (C) 2004-2006 Jason Kivlighn (jkivlighn@gmail.com)          *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#include "pref.h"

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <ntqlayout.h>
#include <ntqlabel.h>
#include <ntqhbox.h>
#include <ntqbuttongroup.h>
#include <ntqcheckbox.h>
#include <ntqradiobutton.h>
#include <ntqpushbutton.h>
#include <ntqtooltip.h>
#include <ntqwhatsthis.h>
#include <ntqframe.h>
#include <ntqcombobox.h>

#include <tdeapplication.h>
#include <tdeconfig.h>
#include <kiconloader.h>
#include <tdelocale.h>
#include <kstandarddirs.h>
#include <tdefiledialog.h>
#include <knuminput.h>
#include <klineedit.h>
#include <kurlrequester.h>
#include <kdebug.h>

KrecipesPreferences::KrecipesPreferences( TQWidget *parent )
		: KDialogBase( IconList, i18n( "Krecipes Preferences" ),
		               Help | Ok | Cancel, Ok, parent )
{
	// this is the base class for your preferences dialog.  it is now
	// a TreeList dialog.. but there are a number of other
	// possibilities (including Tab, Swallow, and just Plain)
	TQFrame * frame;

	TDEConfig *config = TDEGlobal::config();
	config->setGroup( "DBType" );

	TDEIconLoader il;
	frame = addPage( i18n( "Server Settings" ),
	                 TQString( i18n( "Database Server Options (%1)" ) ).arg( config->readEntry( "Type" ) ),
	                 il.loadIcon( "network_local", TDEIcon::NoGroup, 32 ) );
	TQHBoxLayout* layout = new TQHBoxLayout( frame );
	m_pageServer = new ServerPrefs( frame );
	layout->addWidget( m_pageServer );
	m_helpMap.insert(0,"configure-server-settings");

	frame = addPage( i18n( "Formatting" ), i18n( "Customize Formatting" ), il.loadIcon( "math_frac", TDEIcon::NoGroup, 32 ) );
	TQHBoxLayout* formatting_layout = new TQHBoxLayout( frame );
	m_pageNumbers = new NumbersPrefs( frame );
	formatting_layout->addWidget( m_pageNumbers );
	m_helpMap.insert(1,"custom-formatting");

	frame = addPage( i18n( "Import/Export" ), i18n( "Recipe Import and Export Options" ), il.loadIcon( "go-down", TDEIcon::NoGroup, 32 ) );
	TQHBoxLayout* import_layout = new TQHBoxLayout( frame );
	m_pageImport = new ImportPrefs( frame );
	import_layout->addWidget( m_pageImport );
	m_helpMap.insert(2,"import-export-preference");

	frame = addPage( i18n( "Performance" ), i18n( "Performance Options" ), il.loadIcon( "launch", TDEIcon::NoGroup, 32 ) );
	TQHBoxLayout* performance_layout = new TQHBoxLayout( frame );
	m_pagePerformance = new PerformancePrefs( frame );
	performance_layout->addWidget( m_pagePerformance );
	m_helpMap.insert(3,"configure-performance");

	// Signals & Slots
	connect ( this, SIGNAL( okClicked() ), this, SLOT( saveSettings() ) );

}

void KrecipesPreferences::slotHelp()
{
	kapp->invokeHelp( m_helpMap[activePageIndex()] );
}


MySQLServerPrefs::MySQLServerPrefs( TQWidget *parent ) : TQWidget( parent )
{
	TQGridLayout * layout = new TQGridLayout( this, 1, 1, 0, 0 );
	layout->setSpacing( KDialog::spacingHint() );
	layout->setMargin( 0 );

	TQSpacerItem* spacerTop = new TQSpacerItem( 10, 10, TQSizePolicy::Minimum, TQSizePolicy::Fixed );
	layout->addItem( spacerTop, 0, 1 );
	TQSpacerItem* spacerLeft = new TQSpacerItem( 10, 10, TQSizePolicy::Fixed, TQSizePolicy::Minimum );
	layout->addItem( spacerLeft, 1, 0 );

	TQLabel* serverText = new TQLabel( i18n( "Server:" ), this );
	serverText->setFixedSize( TQSize( 100, 20 ) );
	serverText->setSizePolicy( TQSizePolicy::Fixed, TQSizePolicy::Fixed );
	layout->addWidget( serverText, 1, 1 );

	serverEdit = new KLineEdit( this );
	serverEdit->setFixedSize( TQSize( 120, 20 ) );
	serverEdit->setSizePolicy( TQSizePolicy::Fixed, TQSizePolicy::Fixed );
	layout->addWidget( serverEdit, 1, 2 );

	TQSpacerItem* spacerRow1 = new TQSpacerItem( 10, 10, TQSizePolicy::Minimum, TQSizePolicy::Fixed );
	layout->addItem( spacerRow1, 2, 1 );

	TQLabel* usernameText = new TQLabel( i18n( "Username:" ), this );
	usernameText->setFixedSize( TQSize( 100, 20 ) );
	usernameText->setSizePolicy( TQSizePolicy::Fixed, TQSizePolicy::Fixed );
	layout->addWidget( usernameText, 3, 1 );

	usernameEdit = new KLineEdit( this );
	usernameEdit->setFixedSize( TQSize( 120, 20 ) );
	usernameEdit->setSizePolicy( TQSizePolicy::Fixed, TQSizePolicy::Fixed );
	layout->addWidget( usernameEdit, 3, 2 );

	TQSpacerItem* spacerRow2 = new TQSpacerItem( 10, 10, TQSizePolicy::Minimum, TQSizePolicy::Fixed );
	layout->addItem( spacerRow2, 4, 1 );

	TQLabel* passwordText = new TQLabel( i18n( "Password:" ), this );
	passwordText->setFixedSize( TQSize( 100, 20 ) );
	passwordText->setSizePolicy( TQSizePolicy::Fixed, TQSizePolicy::Fixed );
	layout->addWidget( passwordText, 5, 1 );

	passwordEdit = new KLineEdit( this );
	passwordEdit->setFixedSize( TQSize( 120, 20 ) );
	passwordEdit->setEchoMode( TQLineEdit::Password );
	passwordEdit->setSizePolicy( TQSizePolicy::Fixed, TQSizePolicy::Fixed );
	layout->addWidget( passwordEdit, 5, 2 );

	TQSpacerItem* spacerRow3 = new TQSpacerItem( 10, 10, TQSizePolicy::Minimum, TQSizePolicy::Fixed );
	layout->addItem( spacerRow3, 6, 1 );

	TQLabel* portText = new TQLabel( i18n( "Port:" ), this );
	portText->setFixedSize( TQSize( 100, 20 ) );
	portText->setSizePolicy( TQSizePolicy::Fixed, TQSizePolicy::Fixed );
	layout->addWidget( portText, 7, 1 );

	portEdit = new KIntNumInput( this );
	portEdit->setMinValue(0);
	portEdit->setSpecialValueText( i18n("Default") );
	portEdit->setFixedSize( TQSize( 120, 20 ) );
	portEdit->setSizePolicy( TQSizePolicy::Fixed, TQSizePolicy::Fixed );
	layout->addWidget( portEdit, 7, 2 );

	TQSpacerItem* spacerRow4 = new TQSpacerItem( 10, 10, TQSizePolicy::Minimum, TQSizePolicy::Fixed );
	layout->addItem( spacerRow4, 8, 1 );

	TQLabel* dbNameText = new TQLabel( i18n( "Database name:" ), this );
	dbNameText->setFixedSize( TQSize( 100, 20 ) );
	dbNameText->setSizePolicy( TQSizePolicy::Fixed, TQSizePolicy::Fixed );
	layout->addWidget( dbNameText, 9, 1 );

	dbNameEdit = new KLineEdit( this );
	dbNameEdit->setFixedSize( TQSize( 120, 20 ) );
	dbNameEdit->setSizePolicy( TQSizePolicy::Fixed, TQSizePolicy::Fixed );
	layout->addWidget( dbNameEdit, 9, 2 );

	TQSpacerItem* spacerRow5 = new TQSpacerItem( 10, 10, TQSizePolicy::Minimum, TQSizePolicy::MinimumExpanding );
	layout->addItem( spacerRow5, 10, 1 );

	// Backup options
	TQGroupBox *backupGBox = new TQGroupBox( this, "backupGBox" );
	backupGBox->setTitle( i18n( "Backup" ) );
	backupGBox->setColumns( 2 );
	layout->addMultiCellWidget( backupGBox, 10, 10, 1, 4 );

	TQLabel *dumpPathLabel = new TQLabel( backupGBox );
	dumpPathLabel->setText( TQString(i18n( "Path to '%1':" )).arg("mysqldump") );
	dumpPathRequester = new KURLRequester( backupGBox );
	dumpPathRequester->setFilter( "mysqldump" );

	TQLabel *mysqlPathLabel = new TQLabel( backupGBox );
	mysqlPathLabel->setText( TQString(i18n( "Path to '%1':" )).arg("mysql") );
	mysqlPathRequester = new KURLRequester( backupGBox );
	mysqlPathRequester->setFilter( "mysql" );


	TQSpacerItem* spacerRow6 = new TQSpacerItem( 10, 10, TQSizePolicy::Minimum, TQSizePolicy::MinimumExpanding );
	layout->addItem( spacerRow6, 11, 1 );
	TQSpacerItem* spacerRight = new TQSpacerItem( 10, 10, TQSizePolicy::MinimumExpanding, TQSizePolicy::Fixed );
	layout->addItem( spacerRight, 1, 4 );

	// Load & Save Current Settings
	TDEConfig *config = kapp->config();
	config->setGroup( "Server" );
	serverEdit->setText( config->readEntry( "Host", "localhost" ) );
	usernameEdit->setText( config->readEntry( "Username", "" ) );
	passwordEdit->setText( config->readEntry( "Password", "" ) );
	portEdit->setValue( config->readNumEntry( "Port", 0 ) );
	dbNameEdit->setText( config->readEntry( "DBName", "Krecipes" ) );
	dumpPathRequester->setURL( config->readEntry( "MySQLDumpPath", "mysqldump" ) );
	mysqlPathRequester->setURL( config->readEntry( "MySQLPath", "mysql" ) );
}

void MySQLServerPrefs::saveOptions( void )
{
	TDEConfig * config = kapp->config();
	config->setGroup( "Server" );
	config->writeEntry( "Host", serverEdit->text() );
	config->writeEntry( "Username", usernameEdit->text() );
	config->writeEntry( "Password", passwordEdit->text() );
	config->writeEntry( "Port", portEdit->value() );
	config->writeEntry( "DBName", dbNameEdit->text() );
	config->writeEntry( "MySQLDumpPath", dumpPathRequester->url() );
	config->writeEntry( "MySQLPath", mysqlPathRequester->url() );
}


PostgreSQLServerPrefs::PostgreSQLServerPrefs( TQWidget *parent ) : TQWidget( parent )
{
	TQGridLayout * layout = new TQGridLayout( this, 1, 1, 0, 0 );
	layout->setSpacing( KDialog::spacingHint() );
	layout->setMargin( 0 );

	TQSpacerItem* spacerTop = new TQSpacerItem( 10, 10, TQSizePolicy::Minimum, TQSizePolicy::Fixed );
	layout->addItem( spacerTop, 0, 1 );
	TQSpacerItem* spacerLeft = new TQSpacerItem( 10, 10, TQSizePolicy::Fixed, TQSizePolicy::Minimum );
	layout->addItem( spacerLeft, 1, 0 );

	TQLabel* serverText = new TQLabel( i18n( "Server:" ), this );
	serverText->setFixedSize( TQSize( 100, 20 ) );
	serverText->setSizePolicy( TQSizePolicy::Fixed, TQSizePolicy::Fixed );
	layout->addWidget( serverText, 1, 1 );

	serverEdit = new KLineEdit( this );
	serverEdit->setFixedSize( TQSize( 120, 20 ) );
	serverEdit->setSizePolicy( TQSizePolicy::Fixed, TQSizePolicy::Fixed );
	layout->addWidget( serverEdit, 1, 2 );

	TQSpacerItem* spacerRow1 = new TQSpacerItem( 10, 10, TQSizePolicy::Minimum, TQSizePolicy::Fixed );
	layout->addItem( spacerRow1, 2, 1 );

	TQLabel* usernameText = new TQLabel( i18n( "Username:" ), this );
	usernameText->setFixedSize( TQSize( 100, 20 ) );
	usernameText->setSizePolicy( TQSizePolicy::Fixed, TQSizePolicy::Fixed );
	layout->addWidget( usernameText, 3, 1 );

	usernameEdit = new KLineEdit( this );
	usernameEdit->setFixedSize( TQSize( 120, 20 ) );
	usernameEdit->setSizePolicy( TQSizePolicy::Fixed, TQSizePolicy::Fixed );
	layout->addWidget( usernameEdit, 3, 2 );

	TQSpacerItem* spacerRow2 = new TQSpacerItem( 10, 10, TQSizePolicy::Minimum, TQSizePolicy::Fixed );
	layout->addItem( spacerRow2, 4, 1 );

	TQLabel* passwordText = new TQLabel( i18n( "Password:" ), this );
	passwordText->setFixedSize( TQSize( 100, 20 ) );
	passwordText->setSizePolicy( TQSizePolicy::Fixed, TQSizePolicy::Fixed );
	layout->addWidget( passwordText, 5, 1 );

	passwordEdit = new KLineEdit( this );
	passwordEdit->setFixedSize( TQSize( 120, 20 ) );
	passwordEdit->setEchoMode( TQLineEdit::Password );
	passwordEdit->setSizePolicy( TQSizePolicy::Fixed, TQSizePolicy::Fixed );
	layout->addWidget( passwordEdit, 5, 2 );

	TQSpacerItem* spacerRow3 = new TQSpacerItem( 10, 10, TQSizePolicy::Minimum, TQSizePolicy::Fixed );
	layout->addItem( spacerRow3, 6, 1 );

	TQLabel* portText = new TQLabel( i18n( "Port:" ), this );
	portText->setFixedSize( TQSize( 100, 20 ) );
	portText->setSizePolicy( TQSizePolicy::Fixed, TQSizePolicy::Fixed );
	layout->addWidget( portText, 7, 1 );

	portEdit = new KIntNumInput( this );
	portEdit->setMinValue(0);
	portEdit->setSpecialValueText( i18n("Default") );
	portEdit->setFixedSize( TQSize( 120, 20 ) );
	portEdit->setSizePolicy( TQSizePolicy::Fixed, TQSizePolicy::Fixed );
	layout->addWidget( portEdit, 7, 2 );

	TQSpacerItem* spacerRow4 = new TQSpacerItem( 10, 10, TQSizePolicy::Minimum, TQSizePolicy::Fixed );
	layout->addItem( spacerRow4, 8, 1 );

	TQLabel* dbNameText = new TQLabel( i18n( "Database name:" ), this );
	dbNameText->setFixedSize( TQSize( 100, 20 ) );
	dbNameText->setSizePolicy( TQSizePolicy::Fixed, TQSizePolicy::Fixed );
	layout->addWidget( dbNameText, 9, 1 );

	dbNameEdit = new KLineEdit( this );
	dbNameEdit->setFixedSize( TQSize( 120, 20 ) );
	dbNameEdit->setSizePolicy( TQSizePolicy::Fixed, TQSizePolicy::Fixed );
	layout->addWidget( dbNameEdit, 9, 2 );

	TQSpacerItem* spacerRow5 = new TQSpacerItem( 10, 10, TQSizePolicy::Minimum, TQSizePolicy::MinimumExpanding );
	layout->addItem( spacerRow5, 10, 1 );

	// Backup options
	TQGroupBox *backupGBox = new TQGroupBox( this, "backupGBox" );
	backupGBox->setTitle( i18n( "Backup" ) );
	backupGBox->setColumns( 2 );
	layout->addMultiCellWidget( backupGBox, 10, 10, 1, 4 );

	TQLabel *dumpPathLabel = new TQLabel( backupGBox );
	dumpPathLabel->setText( TQString(i18n( "Path to '%1':" )).arg("pg_dump") );
	dumpPathRequester = new KURLRequester( backupGBox );
	dumpPathRequester->setFilter( "pg_dump" );

	TQLabel *psqlPathLabel = new TQLabel( backupGBox );
	psqlPathLabel->setText( TQString(i18n( "Path to '%1':" )).arg("psql") );
	psqlPathRequester = new KURLRequester( backupGBox );
	psqlPathRequester->setFilter( "psql" );


	TQSpacerItem* spacerRow6 = new TQSpacerItem( 10, 10, TQSizePolicy::Minimum, TQSizePolicy::MinimumExpanding );
	layout->addItem( spacerRow6, 11, 1 );
	TQSpacerItem* spacerRight = new TQSpacerItem( 10, 10, TQSizePolicy::MinimumExpanding, TQSizePolicy::Fixed );
	layout->addItem( spacerRight, 1, 4 );

	// Load & Save Current Settings
	TDEConfig *config = kapp->config();
	config->setGroup( "Server" );
	serverEdit->setText( config->readEntry( "Host", "localhost" ) );
	usernameEdit->setText( config->readEntry( "Username", "" ) );
	passwordEdit->setText( config->readEntry( "Password", "" ) );
	portEdit->setValue( config->readNumEntry( "Port", 0 ) );
	dbNameEdit->setText( config->readEntry( "DBName", "Krecipes" ) );
	dumpPathRequester->setURL( config->readEntry( "PgDumpPath", "pg_dump" ) );
	psqlPathRequester->setURL( config->readEntry( "PsqlPath", "psql" ) );
}

void PostgreSQLServerPrefs::saveOptions( void )
{
	TDEConfig * config = kapp->config();
	config->setGroup( "Server" );
	config->writeEntry( "Host", serverEdit->text() );
	config->writeEntry( "Username", usernameEdit->text() );
	config->writeEntry( "Password", passwordEdit->text() );
	config->writeEntry( "Port", portEdit->value() );
	config->writeEntry( "DBName", dbNameEdit->text() );
	config->writeEntry( "PgDumpPath", dumpPathRequester->url() );
	config->writeEntry( "PsqlPath", psqlPathRequester->url() );
}



SQLiteServerPrefs::SQLiteServerPrefs( TQWidget *parent ) : TQWidget( parent )
{
	TQVBoxLayout * Form1Layout = new TQVBoxLayout( this );

	TQHBox *hbox = new TQHBox( this );
	( void ) new TQLabel( i18n( "Database file:" ), hbox );

	fileRequester = new KURLRequester( hbox );
	hbox->setStretchFactor( fileRequester, 2 );

	Form1Layout->addWidget( hbox );

	TQSpacerItem* spacerRow5 = new TQSpacerItem( 10, 10, TQSizePolicy::Minimum, TQSizePolicy::MinimumExpanding );
	Form1Layout->addItem( spacerRow5 );

	TQString sqliteBinary;
	#if HAVE_SQLITE3
	sqliteBinary = "sqlite3";
 	#elif HAVE_SQLITE
	sqliteBinary = "sqlite";
	#endif

	// Backup options
	TQGroupBox *backupGBox = new TQGroupBox( this, "backupGBox" );
	backupGBox->setTitle( i18n( "Backup" ) );
	backupGBox->setColumns( 2 );
	Form1Layout->addWidget( backupGBox );

	TQLabel *dumpPathLabel = new TQLabel( backupGBox );
	dumpPathLabel->setText( TQString(i18n( "Path to '%1':" )).arg(sqliteBinary) );
	dumpPathRequester = new KURLRequester( backupGBox );
	dumpPathRequester->setFilter( sqliteBinary );

	// Load & Save Current Settings
	TDEConfig *config = kapp->config();
	config->setGroup( "Server" );
	fileRequester->setURL( config->readEntry( "DBFile", locateLocal( "appdata", "krecipes.krecdb" ) ) );
	dumpPathRequester->setURL( config->readEntry( "SQLitePath", sqliteBinary ) );
}

void SQLiteServerPrefs::saveOptions( void )
{
	TDEConfig * config = kapp->config();
	config->setGroup( "Server" );
	config->writeEntry( "DBFile", fileRequester->url() );
	config->writeEntry( "SQLitePath", dumpPathRequester->url() );
}


// Server Setttings Dialog
ServerPrefs::ServerPrefs( TQWidget *parent )
		: TQWidget( parent )
{
	TQVBoxLayout * Form1Layout = new TQVBoxLayout( this, 11, 6 );

	TDEConfig *config = kapp->config();
	config->setGroup( "DBType" );
	TQString DBtype = config->readEntry( "Type" );
	if ( DBtype == "MySQL" )
		serverWidget = new MySQLServerPrefs( this );
	else if ( DBtype == "PostgreSQL" )
		serverWidget = new PostgreSQLServerPrefs( this );
	else
		serverWidget = new SQLiteServerPrefs( this );

	serverWidget->setSizePolicy( TQSizePolicy::MinimumExpanding, TQSizePolicy::Minimum );
	Form1Layout->addWidget( serverWidget );

	Form1Layout->addItem( new TQSpacerItem( 20, 40, TQSizePolicy::Minimum, TQSizePolicy::Expanding ) );

	wizard_button = new TQCheckBox( i18n( "Re-run wizard on next startup" ), this );
	wizard_button->setSizePolicy( TQSizePolicy::MinimumExpanding, TQSizePolicy::Minimum );
	Form1Layout->addWidget( wizard_button );

	TQLabel *note = new TQLabel( i18n( "Note: Krecipes must be restarted for most server preferences to take effect." ), this );
	Form1Layout->addWidget( note );

	adjustSize();
}


void KrecipesPreferences::saveSettings( void )
{
	m_pageServer->saveOptions();
	m_pageNumbers->saveOptions();
	m_pageImport->saveOptions();
	m_pagePerformance->saveOptions();
}

// Save Server settings
void ServerPrefs::saveOptions( void )
{
	TDEConfig * config = kapp->config();
	config->setGroup( "DBType" );
	TQString DBtype = config->readEntry( "Type" );
	if ( DBtype == "MySQL" )
		( ( MySQLServerPrefs* ) serverWidget ) ->saveOptions();
	else if ( DBtype == "PostgreSQL" )
		( ( PostgreSQLServerPrefs* ) serverWidget ) ->saveOptions();
	else
		( ( SQLiteServerPrefs* ) serverWidget ) ->saveOptions();

	if ( wizard_button->isChecked() ) {
		config->setGroup( "Wizard" );
		config->writeEntry( "SystemSetup", false );
	}
}

//=============Numbers Preferences Dialog================//
NumbersPrefs::NumbersPrefs( TQWidget *parent )
		: TQWidget( parent )
{
	Form1Layout = new TQVBoxLayout( this, 11, 6 );

	numberButtonGroup = new TQButtonGroup( this );
	numberButtonGroup->setColumnLayout( 0, TQt::Vertical );
	numberButtonGroup->layout() ->setSpacing( 6 );
	numberButtonGroup->layout() ->setMargin( 11 );
	numberButtonGroup->resize( TQSize() );
	numberButtonGroupLayout = new TQVBoxLayout( numberButtonGroup->layout() );
	numberButtonGroupLayout->setAlignment( TQt::AlignTop );

	fractionRadioButton = new TQRadioButton( numberButtonGroup );
	numberButtonGroupLayout->addWidget( fractionRadioButton );

	decimalRadioButton = new TQRadioButton( numberButtonGroup );
	numberButtonGroupLayout->addWidget( decimalRadioButton );
	Form1Layout->addWidget( numberButtonGroup );

	numberButtonGroup->insert( decimalRadioButton, 0 );
	numberButtonGroup->insert( fractionRadioButton, 1 );

	//ingredient display format
	TQGroupBox *ingredientGrpBox = new TQGroupBox( 2, TQt::Vertical, i18n( "Ingredients" ), this );

	TQHBox *ingredientBox = new TQHBox( ingredientGrpBox );
	( void ) new TQLabel( i18n( "Ingredient Format:" ), ingredientBox );
	ingredientEdit = new KLineEdit( ingredientBox );
	( void ) new TQLabel( i18n( "%n: Name<br>"
	                           "%p: Preparation method<br>"
	                           "%a: Amount<br>"
	                           "%u: Unit"
	                         ), ingredientGrpBox );

	Form1Layout->addWidget( ingredientGrpBox );

	//unit display format
	TQGroupBox *abbrevGrpBox = new TQGroupBox( 1, TQt::Vertical, i18n( "Units" ), this );
	TQHBox *abbrevBox = new TQHBox( abbrevGrpBox );
	abbrevButton = new TQCheckBox( i18n( "Use abbreviations" ), abbrevBox );
	Form1Layout->addWidget( abbrevGrpBox );


	Form1Layout->addItem( new TQSpacerItem( 20, 40, TQSizePolicy::Minimum, TQSizePolicy::Expanding ) );

	adjustSize();

	languageChange();

	// Load Current Settings
	TDEConfig *config = kapp->config();
	config->setGroup( "Formatting" );

	int button = ( config->readBoolEntry( "Fraction", false ) ) ? 1 : 0;
	numberButtonGroup->setButton( button );

	ingredientEdit->setText( config->readEntry( "Ingredient", "%n%p: %a %u" ) );

	abbrevButton->setChecked( config->readBoolEntry( "AbbreviateUnits", false ) );
}

void NumbersPrefs::saveOptions()
{
	TDEConfig * config = kapp->config();
	config->setGroup( "Formatting" );

	bool fraction = !numberButtonGroup->find( 0 ) ->isOn();
	config->writeEntry( "Fraction", fraction );

	config->writeEntry( "Ingredient", ingredientEdit->text() );

	config->writeEntry( "AbbreviateUnits", abbrevButton->isChecked() );
}

void NumbersPrefs::languageChange()
{
	numberButtonGroup->setTitle( i18n( "Number Format" ) );
	fractionRadioButton->setText( i18n( "Fraction" ) );
	decimalRadioButton->setText( i18n( "Decimal" ) );
}

//=============Import/Export Preferences Dialog================//
ImportPrefs::ImportPrefs( TQWidget *parent )
		: TQWidget( parent )
{
	// Load Current Settings
	TDEConfig * config = kapp->config();
	config->setGroup( "Import" );

	bool overwrite = config->readBoolEntry( "OverwriteExisting", false );
	bool direct = config->readBoolEntry( "DirectImport", false );

	Form1Layout = new TQVBoxLayout( this, 11, 6 );

	TQGroupBox *importGroup = new TQGroupBox(2,TQt::Vertical,i18n("Import"), this);

	overwriteCheckbox = new TQCheckBox( i18n( "Overwrite recipes with same title" ), importGroup );
	overwriteCheckbox->setChecked( overwrite );
	overwriteCheckbox->setSizePolicy( TQSizePolicy::MinimumExpanding, TQSizePolicy::Minimum );

	directImportCheckbox = new TQCheckBox( i18n( "Ask which recipes to import" ), importGroup );
	directImportCheckbox->setChecked( !direct );
	directImportCheckbox->setSizePolicy( TQSizePolicy::MinimumExpanding, TQSizePolicy::Minimum );

	Form1Layout->addWidget(importGroup);

	TQGroupBox *exportGroup = new TQGroupBox(1,TQt::Vertical,i18n("Export"), this);

	TQHBox *clipboardHBox = new TQHBox(exportGroup);
	clipboardHBox->setSpacing(6);
	TQLabel *clipboardLabel = new TQLabel(i18n("'Copy to Clipboard' format:"),clipboardHBox);
	clipBoardFormatComboBox = new TQComboBox( clipboardHBox );
	clipBoardFormatComboBox->insertItem(TQString("%3 (*.txt)").arg(i18n("Plain Text")));
	clipBoardFormatComboBox->insertItem("Krecipes (*.kreml)");
	clipBoardFormatComboBox->insertItem("Meal-Master (*.mmf)");
	clipBoardFormatComboBox->insertItem("Rezkonv (*.rk)");
	clipBoardFormatComboBox->insertItem("RecipeML (*.xml)");
	//clipBoardFormatComboBox->insertItem("CookML (*.cml)");
	clipboardHBox->setStretchFactor(clipBoardFormatComboBox,1);

	config->setGroup( "Export" );
	TQString clipboardFormat = config->readEntry("ClipboardFormat");
	if ( clipboardFormat == "*.kreml" )
		clipBoardFormatComboBox->setCurrentItem(1);
	else if ( clipboardFormat == "*.mmf" )
		clipBoardFormatComboBox->setCurrentItem(2);
	else if ( clipboardFormat == "*.xml" )
		clipBoardFormatComboBox->setCurrentItem(3);
	else
		clipBoardFormatComboBox->setCurrentItem(0);

	Form1Layout->addWidget(exportGroup);

	Form1Layout->addItem( new TQSpacerItem( 20, 40, TQSizePolicy::Minimum, TQSizePolicy::Expanding ) );

	TQWhatsThis::add( directImportCheckbox, 
		i18n("When this is enabled, the importer will show every recipe in the file(s) and allow you to select which recipes you want imported.\n \
							\
		Disable this to always import every recipe, which allows for faster and less memory-intensive imports.")
	);

	adjustSize();
}

void ImportPrefs::saveOptions()
{
	TDEConfig * config = kapp->config();
	config->setGroup( "Import" );

	config->writeEntry( "OverwriteExisting", overwriteCheckbox->isChecked() );
	config->writeEntry( "DirectImport", !directImportCheckbox->isChecked() );

	config->setGroup( "Export" );
	TQString ext = clipBoardFormatComboBox->currentText().mid(clipBoardFormatComboBox->currentText().find("(")+1,clipBoardFormatComboBox->currentText().length()-clipBoardFormatComboBox->currentText().find("(")-2);
	config->writeEntry( "ClipboardFormat", ext );
}


//=============Performance Options Dialog================//
PerformancePrefs::PerformancePrefs( TQWidget *parent )
		: TQWidget( parent )
{
	// Load Current Settings
	TDEConfig * config = kapp->config();
	config->setGroup( "Performance" );

	int cat_limit = config->readNumEntry( "CategoryLimit", -1 );
	int limit = config->readNumEntry( "Limit", -1 );

	Form1Layout = new TQVBoxLayout( this, 11, 6 );

	searchAsYouTypeBox = new TQCheckBox( i18n( "Search as you type" ), this );
	searchAsYouTypeBox->setChecked( config->readBoolEntry( "SearchAsYouType", true ) );

	TQLabel *explainationLabel = new TQLabel( i18n("In most instances these options do not need to be changed.  However, limiting the amount of items displayed at once will <b>allow Krecipes to better perform when the database is loaded with many thousands of recipes</b>."), this );
	explainationLabel->setTextFormat( TQt::RichText );

	TQHBox *catLimitHBox = new TQHBox( this );
	catLimitInput = new KIntNumInput(catLimitHBox);
	catLimitInput->setLabel( i18n( "Number of categories to display at once:" ) );
	catLimitInput->setRange(0,5000,20,true);
	catLimitInput->setSpecialValueText( i18n("Unlimited") );

	if ( cat_limit > 0 )
		catLimitInput->setValue( cat_limit );

	TQHBox *limitHBox = new TQHBox( this );
	limitInput = new KIntNumInput(limitHBox);
	limitInput->setLabel( i18n( "Number of elements to display at once:" ) );
	limitInput->setRange(0,100000,1000,true);
	limitInput->setSpecialValueText( i18n("Unlimited") );

	if ( limit > 0 )
		limitInput->setValue( limit );

	Form1Layout->addWidget( searchAsYouTypeBox );
	Form1Layout->addWidget( explainationLabel );
	Form1Layout->addWidget( catLimitHBox );
	Form1Layout->addWidget( limitHBox );

	Form1Layout->addItem( new TQSpacerItem( 20, 40, TQSizePolicy::Minimum, TQSizePolicy::Expanding ) );

	adjustSize();
}

void PerformancePrefs::saveOptions()
{
	TDEConfig * config = kapp->config();
	config->setGroup( "Performance" );

	int catLimit = ( catLimitInput->value() == 0 ) ? -1 : catLimitInput->value();
	config->writeEntry( "CategoryLimit", catLimit );

	int limit = ( limitInput->value() == 0 ) ? -1 : limitInput->value();
	config->writeEntry( "Limit", limit );

	config->writeEntry( "SearchAsYouType", searchAsYouTypeBox->isChecked() );
}

#include "pref.moc"
