/***************************************************************************
*   Copyright (C) 2003-2005 by Jason Kivlighn                             *
*   (jkivlighn@gmail.com)                                                 *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef PAGESETUPDIALOG_H
#define PAGESETUPDIALOG_H

#include <ntqmap.h>

#include <kdialog.h>

#include "datablocks/recipe.h"

class TDEPopupMenu;

class SetupDisplay;
class KreDisplayItem;

/**
  * @author Jason Kivlighn
  */
class PageSetupDialog : public KDialog
{
	Q_OBJECT

public:
	PageSetupDialog( TQWidget *parent, const Recipe &sample, const TQString &configEntry = TQString::null );
	~PageSetupDialog()
	{}

protected:
	virtual void accept();
	virtual void reject();
	void save();

private slots:
	void loadFile();
	void loadLayout( int );
	void loadLayout( const TQString &filename );
	void loadTemplate( int );
	void reloadLayout();
	void saveLayout();
	void saveAsLayout();
	void updateItemVisibility( KreDisplayItem*, bool );
	void setItemShown( int id );

private:
	TQString getIncludedLayoutDir() const;
	void setActiveFile( const TQString &filename );
	bool haveWritePerm( const TQString &filename );
	void initShownItems();

	SetupDisplay *m_htmlPart;

	TQString active_filename;
	TQString active_template;
	bool have_write_perm;
	TQString m_configEntry;

	TQMap<int, KreDisplayItem*> popup_widget_map;
	TQMap<KreDisplayItem*, int> widget_popup_map;
	TQMap<int, TQString> included_layouts_map;
	TDEPopupMenu *shown_items_popup;
};

#endif //PAGESETUPDIALOG_H
