#ifndef _SysInfo_CONDUIT_H
#define _SysInfo_CONDUIT_H
/* sysinfo-conduit.h                           KPilot
**
** Copyright (C) 2003 by Reinhold Kainhofer
**
*/

/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program in a file called COPYING; if not, write to
** the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
** MA 02110-1301, USA.
*/

/*
** Bug reports and questions can be sent to kde-pim@kde.org
*/


#include <plugin.h>

class SysInfoConduit : public ConduitAction
{
	Q_OBJECT
  
public:
	SysInfoConduit(
		KPilotLink *o,
		const char *n = 0L,
		const TQStringList &a = TQStringList() );
	virtual ~SysInfoConduit();
	virtual bool exec();

public slots:
	void hardwareInfo();
	void userInfo();
	void memoryInfo();
	void storageInfo();
	void dbListInfo();
	void recNumberInfo();
	void syncInfo();
	void pcVersionInfo();
	void palmVersionInfo();
	void debugInfo();
	void writeFile();
	void cleanup();

protected:
	void readConfig();
private:
	TQMap<TQString,TQString> fValues;

	bool fHardwareInfo, fUserInfo, fMemoryInfo, fStorageInfo,
		fDBList, fRecordNumber, fSyncInfo,
		fKDEVersion, fPalmOSVersion, fDebugInfo;
	TQString fOutputFile, fTemplateFile;
	enum eOutputTypeEnum {
		eOutputHTML=0,
		eOutputText,
		eOutputTemplate
	} fOutputType;

	KPilotLink::DBInfoList dblist;
	TQStringList removeParts;
	TQStringList keepParts;
	static const TQString defaultpage;
} ;

#endif
