/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
*/

/*
  Copyright (C) 2003 Dario Abatianni <eisfuchs@tigress.com>
  Copyright (C) 2006-2008 Eike Hein <hein@kde.org>
*/

#ifndef STATUSPANEL_H
#define STATUSPANEL_H

#include "chatwindow.h"

#include <tqstring.h>


class TQPushButton;
class TQCheckBox;
class TQLabel;
class TQComboBox;

class IRCInput;
class NickChangeDialog;

class StatusPanel : public ChatWindow
{
    Q_OBJECT
  

    public:
        explicit StatusPanel(TQWidget* parent);
        ~StatusPanel();

        virtual void setName(const TQString& newName);

        virtual TQString getTextInLine();
        virtual bool closeYourself(bool askForConfirmation=true);
        virtual bool canBeFrontView();
        virtual bool searchView();

        virtual void setChannelEncoding(const TQString& encoding);
        virtual TQString getChannelEncoding();
        virtual TQString getChannelEncodingDefaultDesc();
        virtual void emitUpdateInfo();

        void setIdentity(const IdentityPtr identity);

        virtual bool isInsertSupported() { return true; }

        virtual void setNotificationsEnabled(bool enable);

    signals:
        void sendFile();

    public slots:
        void setNickname(const TQString& newNickname);
        virtual void indicateAway(bool show);
        void showNicknameBox(bool show);
        void updateAppearance();
        virtual void appendInputText(const TQString&, bool fromCursor);
        void updateName();
        void serverSaysClose();

    protected slots:
        void sendFileMenu();
        void statusTextEntered();
        void sendStatusText(const TQString& line);
        // connected to IRCInput::textPasted() - used for large/multiline pastes
        void textPasted(const TQString& text);
        void changeNickname(const TQString& newNickname);
        void nicknameComboboxChanged();
        //Used to disable functions when not connected
        virtual void serverOnline(bool online);

        void popupCommand(int command);

    protected:

        /** Called from ChatWindow adjustFocus */
        virtual void childAdjustFocus();

        bool awayChanged;
        bool awayState;

        void showEvent(TQShowEvent* event);

        TQComboBox* nicknameCombobox;
        TQLabel* awayLabel;
        IRCInput* statusInput;
        TQCheckBox* logCheckBox;
        TQString oldNick;
};
#endif
