/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
*/

/*
  Copyright (C) 2005 Ismail Donmez <ismail@kde.org>
  Copyright (C) 2006 John Tapsell <johnflux@gmail.com>
*/

#include "dcc_preferences.h"

#include <tqcombobox.h>
#include <tqlineedit.h>
#include <tdelocale.h>


DCC_Config::DCC_Config(TQWidget *parent, const char* name) :
  DCC_ConfigUI(parent,name)
{
    languageChange();
    connect(kcfg_DccMethodToGetOwnIp, TQT_SIGNAL(activated(int)), this, TQT_SLOT(dccMethodChanged(int)));          dccMethodChanged(kcfg_DccMethodToGetOwnIp->currentItem()); 


}

void DCC_Config::show()
{
    TQWidget::show();

    kcfg_DccSpecificOwnIp->setEnabled(kcfg_DccMethodToGetOwnIp->currentItem() == 2);
}

void DCC_Config::dccMethodChanged(int index)
{
    kcfg_DccSpecificOwnIp->setEnabled( index == 2 ); 
}

void DCC_Config::languageChange()
{
    kcfg_DccMethodToGetOwnIp->clear();
    kcfg_DccMethodToGetOwnIp->insertItem(i18n("Network Interface"));
    kcfg_DccMethodToGetOwnIp->insertItem(i18n("Reply From IRC Server"));
    kcfg_DccMethodToGetOwnIp->insertItem(i18n("Specify Manually"));

}

DCC_Config::~DCC_Config()
{
}
#include "dcc_preferences.moc"

