/***************************************************************************
 *   Copyright (C) 2004 by Hans Oischinger                                 *
 *   hans.oischinger@kde-mail.net                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KOMPOSEDESKTOPWIDGET_H
#define KOMPOSEDESKTOPWIDGET_H

#include "komposetaskcontainerwidget.h"

class KomposeLayout;
class KomposeTask;
class KRootPixmap;
/**
@author Hans Oischinger
*/
class KomposeDesktopWidget : public KomposeTaskContainerWidget
{
  Q_OBJECT
public:
  KomposeDesktopWidget(int desktop, TQWidget *parent = 0, KomposeLayout *l = 0, const char *name = 0);

  ~KomposeDesktopWidget();

  void setHighlight();
  void clearHighlight();
  void setInactive();
  void setActive();

  //   int getHeightForWidth( int w ) const;
  //   int getWidthForHeight( int h ) const;
  //   double getAspectRatio();

signals:
  void contentsChanged();
  void activated(KomposeDesktopWidget*);

protected:
  void paintEvent ( TQPaintEvent * );
  void dragEnterEvent ( TQDragEnterEvent * );
  void dropEvent ( TQDropEvent * );
  void leaveEvent ( TQEvent * );
  void enterEvent ( TQEvent * );
  void mouseReleaseEvent ( TQMouseEvent * e );
  void mouseDoubleClickEvent ( TQMouseEvent * e );
  void childEvent( TQChildEvent * ce);
  void focusInEvent ( TQFocusEvent * );
  void focusOutEvent ( TQFocusEvent * );
  void keyReleaseEvent ( TQKeyEvent * e );

protected slots:
  void initFonts();

private:
  TQRect deskRect;
  TQString deskName;
  bool highlight; // Highlight widget?
  TQFont titleFont;
  KRootPixmap *rootpix;
};

#endif
