/* This file is part of the KDE project
   Copyright (C) 2003 - 2005 Dag Andersen <danders@get2net.dk>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation;
   version 2 of the License.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef KPTREPORTVIEW_H
#define KPTREPORTVIEW_H

#include "kptcontext.h"
#include "kptproject.h"
#include "kpttask.h"
#include "kptresource.h"
#include "kptduration.h"
#include <tqsplitter.h>
#include <tqstring.h>

#include <tdelistview.h>

class TDEAction;
class KPrinter;

namespace Kugar
{
  class MReportViewer;
} // Kugar namespace

//class TQString;
class TQStringList;
class TQDomDocument;
class TQDomNode;
class TQIODevice;

namespace KPlato
{

class View;
class Node;
class KugarReportViewer;
class ReportTagsPrivate;

class ReportView : public TQSplitter
{
    Q_OBJECT
  

 public:

    ReportView(View *view, TQWidget *parent);

    ~ReportView();

	void zoom(double /*zoom*/) {}

    void draw(const TQString &report);
    View *mainView() const { return m_mainview; }

    void setup(KPrinter &printer);
    void print(KPrinter &printer);

    void setReportData();

    void getTemplateFile(const TQString &tpl);
    void openTemplateFile(const TQString &file);
    void loadTemplate(TQIODevice &dev);
    void loadTemplate(TQDomDocument &doc);
    void handleHeader(TQDomNode &node);
    void handleDetail(TQDomElement &elem);
    void handleKPlato(TQDomElement &elem);
    void replaceTags(TQDomNode &node);

    TQString setReportDetail();
    TQString setTaskChildren(Node *node);
    TQString setTaskDetail(Node *node);
    TQStringList getProperties(TQDomElement &elem);

    TQString setResourceDetail(Resource *res);
    TQString setResourceGroupDetail(ResourceGroup *group);

    TQString setDetail(const TQString &source, TQStringList &properties, TQString &level);

    virtual bool setContext(Context::Reportview &context);
    virtual void getContext(Context::Reportview &context) const;

    void enableNavigationBtn();
    
signals:
    void setFirstPageActionEnabled(bool);
    void setNextPageActionEnabled(bool);
    void setPriorPageActionEnabled(bool);
    void setLastPageActionEnabled(bool);

public slots:
	void slotFirstPage();
	void slotNextPage();
	void slotPrevPage();
	void slotLastPage();

protected slots:
    void slotReportListClicked(TQListViewItem* item);
    void slotReportListSelectionChanged(TQListViewItem* item);
    
private:
    class ReportItem : public TDEListViewItem {
    public:
        ReportItem(TDEListView *p, TQString name, TQString _url) 
            : TDEListViewItem(p, name),
              url(_url)
        {}
        TQString url;
    };
    void initReportList();
    
private:
    View *m_mainview;
    TDEListView *m_reportList;
    KugarReportViewer *m_reportview;
    int m_defaultFontSize;

    TQDomDocument templateDoc;

    ReportTagsPrivate *m_reportTags;
};

}  //KPlato namespace

#endif
