/* This file is part of the KDE project
   Copyright (C) 2005-2007 Jaroslaw Staniek <js@iidea.pl>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef KexiFrame_H
#define KexiFrame_H

#include <tqframe.h>

//! @short Frame widget for Kexi forms
class KEXIFORMUTILS_EXPORT KexiFrame : public TQFrame
{
	Q_OBJECT
  
//todo	TQ_ENUMS( Shape Shadow )
	TQ_PROPERTY( TQColor frameColor READ frameColor WRITE setFrameColor DESIGNABLE true )
//todo	TQ_OVERRIDE( Shape frameShape READ frameShape WRITE setFrameShape )
//todo	TQ_OVERRIDE( Shadow frameShadow READ frameShadow WRITE setFrameShadow )

	public:
		KexiFrame( TQWidget * parent, const char * name = 0, WFlags f = 0 );
		virtual ~KexiFrame();

		virtual const TQColor& frameColor() const;

#if 0
//! @todo more options
		enum Shadow {
			NoShadow = TQFrame::Plain,
			Raised = TQFrame::Raised,
			Sunken = TQFrame::Sunken
		};
//! @todo more options
		enum Shape { NoFrame = TQFrame::NoFrame, //!< no frame
			Box = TQFrame::Box,                  //!< rectangular box
			Panel = TQFrame::Panel,              //!< rectangular panel
			StyledPanel = TQFrame::StyledPanel,  //!< rectangular panel depending on the GUI style
			GroupBoxPanel = TQFrame::GroupBoxPanel //!< rectangular group-box-like panel depending on the GUI style
		};
		Shape frameShape() const;
		void setFrameShape( KexiFrame::Shape shape );
		Shadow frameShadow() const;
		void setFrameShadow( KexiFrame::Shadow shadow );
#endif

		//! Used to emit handleDragMoveEvent() signal needed to control dragging over the container's surface
		virtual void dragMoveEvent( TQDragMoveEvent *e );

		//! Used to emit handleDropEvent() signal needed to control dropping on the container's surface
		virtual void dropEvent( TQDropEvent *e );

	public slots:
		virtual void setPalette( const TQPalette &pal );
		virtual void setFrameColor(const TQColor& color);

	signals:
		//! Needed to control dragging over the container's surface
		void handleDragMoveEvent(TQDragMoveEvent *e);

		//! Needed to control dropping on the container's surface
		void handleDropEvent(TQDropEvent *e);

	protected:
		virtual void drawFrame( TQPainter * );

		class Private;
		Private *d;
};

#endif
