/* This file is part of the KDE project
   Copyright (C) 2002, 2003 The Karbon Developers

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef __XAMLEXPORT_H__
#define __XAMLEXPORT_H__

#include <KoFilter.h>

#include "vvisitor.h"
#include "vgradient.h"

#include "xamlgraphiccontext.h"

#include <tqptrstack.h>

class TQTextStream;
class VColor;
class VPath;
class VDocument;
class VFill;
class VGroup;
class VLayer;
class VSubpath;
class VStroke;
class VText;


class XAMLExport : public KoFilter, private VVisitor
{
	Q_OBJECT
  

public:
	XAMLExport( KoFilter* parent, const char* name, const TQStringList& );
	virtual ~XAMLExport() {}

	virtual KoFilter::ConversionStatus convert( const TQCString& from, const TQCString& to );

private:
	virtual void visitVPath( VPath& composite );
	virtual void visitVDocument( VDocument& document );
	virtual void visitVGroup( VGroup& group );
	virtual void visitVSubpath( VSubpath& path );
	//virtual void visitVText( VText& text );

	void getStroke( const VStroke& stroke );
	void getColorStops( const TQPtrVector<VColorStop> &colorStops );
	void getFill( const VFill& fill  );
	void getGradient( const VGradient& grad );
	void getHexColor( TQTextStream *, const VColor& color  );
	TQString getID( VObject *obj );

	TQTextStream* m_stream;
	TQTextStream* m_defs;
	TQTextStream* m_body;

	TQPtrStack<XAMLGraphicsContext>	m_gc;
};

#endif

