/* This file is part of the KDE project
   Copyright (C) 1998, 1999 Reginald Stadlbauer <reggie@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef footnotedia_h
#define footnotedia_h

#include <kdialogbase.h>
#include "defs.h" // for NoteType
#include "KWVariable.h"
class TQRadioButton;
class TQLineEdit;
class KWDocument;
/******************************************************************/
/* Class: KWFootNoteDia                                           */
/******************************************************************/

class KWFootNoteDia : public KDialogBase
{
    Q_OBJECT
  

public:
    KWFootNoteDia( NoteType _noteType, KWFootNoteVariable::Numbering _numberingType,  const TQString & _manualString, TQWidget *parent, KWDocument *_doc, const char *name = 0 );

    NoteType noteType() const;
    KWFootNoteVariable::Numbering numberingType()const;
    TQString manualString()const;
    void appendManualFootNote( const TQString & );
protected:
    bool insertFootNote();
    bool footNoteAlreadyExists( const TQString & );
protected slots:
    void footLineChanged( const TQString & );
    void footNoteTypeChanged();
    void slotConfigurate();
private:

    TQRadioButton *m_rbAuto;
    TQRadioButton *m_rbManual;

    TQRadioButton *m_rbFootNote;
    TQRadioButton *m_rbEndNote;
    TQLineEdit *m_footLine;
    KWDocument *m_doc;
    TQValueList<TQString> manualFootNotes;
};

#endif


