/*
 *  dlg_shearimage.cc - part of KimageShop^WKrayon^WChalk
 *
 *  Copyright (c) 2004 Michael Thaler <michael.thaler@physik.tu-muenchen.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <config.h>

#include <math.h>

#include <iostream>

using namespace std;

#include <tqradiobutton.h>
#include <tqcheckbox.h>
#include <tqlabel.h>
#include <tqlayout.h>

#include <tdelocale.h>
#include <knuminput.h>
#include <kdebug.h>

#include "dlg_shearimage.h"
#include "wdg_shearimage.h"


DlgShearImage::DlgShearImage( TQWidget *  parent,
                const char * name)
    : super (parent, name, true, i18n("Shear Image"), Ok | Cancel, Ok)
{
    m_lock = false;

    m_page = new WdgShearImage(this, "shear_image");
    m_page->layout()->setMargin(0);
    TQ_CHECK_PTR(m_page);

    setMainWidget(m_page);
    resize(m_page->sizeHint());

    connect(this, TQT_SIGNAL(okClicked()),
        this, TQT_SLOT(okClicked()));

}

DlgShearImage::~DlgShearImage()
{
    delete m_page;
}

void DlgShearImage::setAngleX(TQ_UINT32 angle) 
{
    m_page->shearAngleX->setValue(angle);
    m_oldAngle = angle;

}

void DlgShearImage::setAngleY(TQ_UINT32 angle) 
{
    m_page->shearAngleY->setValue(angle);
    m_oldAngle = angle;

}

TQ_INT32 DlgShearImage::angleX()
{
    return (TQ_INT32)tqRound(m_page->shearAngleX->value());
}

TQ_INT32 DlgShearImage::angleY()
{
    return (TQ_INT32)tqRound(m_page->shearAngleY->value());
}

// SLOTS

void DlgShearImage::okClicked()
{
    accept();
}

#include "dlg_shearimage.moc"
