/* This file is part of the KDE project
   Copyright (C) 2002 Bo Thorsen  bo@sonofthor.dk

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#include <tqpushbutton.h>
#include <tqcombobox.h>
#include <tqlabel.h>
#include <tqtextedit.h>
#include <tqlineedit.h>
#include <tqdatetimeedit.h>
#include <tqdatetime.h>
#include <tqtabwidget.h>
#include <tqtextbrowser.h>

#include <kdatepicker.h>
#include <tdelocale.h>

#include <tdeabc/addressee.h>
#include <tdeabc/addresseedialog.h>

#include <kdebug.h>

#include "kptprojectdialog.h"
#include "kptproject.h"
#include "kptresource.h"
#include "kptprojectdialogbase.h"
#include "kptresourcespanel.h"

namespace KPlato
{

ProjectDialog::ProjectDialog(Project &p, TQWidget *parent, const char *name)
    : KDialogBase( Swallow, i18n("Project Settings"), Ok|Cancel, Ok, parent, name, true, true),
      project(p)
{
    dia = new ProjectDialogImpl(this);
    resourcesTab = new ResourcesPanel(dia, &project);
    dia->daTabs->insertTab(resourcesTab, i18n("Resources"), 1);
    setMainWidget(dia);
    enableButtonOK(false);

	dia->namefield->setText(project.name());
	dia->leaderfield->setText(project.leader());

    connect(dia, TQT_SIGNAL( obligatedFieldsFilled(bool) ), this, TQT_SLOT( enableButtonOK(bool) ));
    connect(dia, TQT_SIGNAL( schedulingTypeChanged(int) ), this, TQT_SLOT( slotSchedulingChanged(int) ));

    slotSchedulingChanged(dia->schedulerType->currentItem());
    dia->namefield->setFocus();

    connect(resourcesTab, TQT_SIGNAL( changed() ), dia, TQT_SLOT( slotCheckAllFieldsFilled() ));
}


void ProjectDialog::slotOk() {
    project.setConstraint((Node::ConstraintType) dia->schedulerType->currentItem());
    //FIXME
    project.setStartTime(TQDateTime(dia->schedulerDate->date(), dia->schedulerTime->time()));
    project.setConstraintStartTime(TQDateTime(dia->schedulerDate->date(), dia->schedulerTime->time()));

    project.setName(dia->namefield->text());
    project.setLeader(dia->leaderfield->text());
    project.setDescription(dia->descriptionfield->text());

	resourcesTab->ok();

    accept();
}

void ProjectDialog::slotSchedulingChanged(int activated) {
    bool needDate = activated >= 2;
    dia->schedulerTime->setEnabled(needDate);
    dia->schedulerDate->setEnabled(needDate);

    TQString label = TQString("<p><font size=\"4\" color=\"#7797BC\"><b>%1</b></font></p><p>%2</p>");
    switch(activated) {
        // TODO please provide nice explenations on this.
        case 0: // ASAP
            label = label.arg(i18n("As Soon as Possible"));
            label = label.arg(i18n("Place all events at the earliest possible moment permitted in the schedule"));
            break;
        case 1: // ALAP
            label = label.arg(i18n("As Late as Possible"));
            label = label.arg(i18n("Place all events at the last possible moment permitted in the schedule"));
            break;
        case 2: // Start not earlier then
            label = label.arg(i18n("Start not Earlier then"));
            label = label.arg(i18n(""));
            break;
        case 3: // Finish not later then
            label = label.arg(i18n("Finish not Later then"));
            label = label.arg(i18n(""));
            break;
        case 4: // Must start on
            label = label.arg(i18n("Must Start on"));
            label = label.arg(i18n(""));
            break;
        default: // error ...
            dia->lSchedulingExplain->setText("");
            return;
    }
    dia->lSchedulingExplain->setText(label);
}

ProjectDialogImpl::ProjectDialogImpl (TQWidget *parent) : ProjectDialogBase(parent) {
    connect (namefield, TQT_SIGNAL(textChanged( const TQString& )), this, TQT_SLOT(slotCheckAllFieldsFilled()) );
    connect (leaderfield, TQT_SIGNAL(textChanged( const TQString& )), this, TQT_SLOT(slotCheckAllFieldsFilled()) );
    connect (schedulerType, TQT_SIGNAL(activated( int )), this, TQT_SLOT(slotSchedulingChanged( int )) );
	connect (chooseLeader, TQT_SIGNAL(pressed()), this, TQT_SLOT(slotChooseLeader()));
}

void ProjectDialogImpl::slotCheckAllFieldsFilled() {
    emit obligatedFieldsFilled( !(namefield->text().isEmpty() || leaderfield->text().isEmpty()));
}

void ProjectDialogImpl::slotSchedulingChanged(int activated) {
    emit schedulingTypeChanged(activated);
}

void ProjectDialogImpl::slotChooseLeader()
{
  TDEABC::Addressee a = TDEABC::AddresseeDialog::getAddressee(this);
  if (!a.isEmpty()) {
	  leaderfield->setText(a.fullEmail());
  }
}

}  //KPlato namespace

#include "kptprojectdialog.moc"
