/*
 * default_tools.cc -- Part of Chalk
 *
 * Copyright (c) 2004 Boudewijn Rempt (boud@valdyas.org)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
#include <stdlib.h>
#include <vector>

#include <tqpoint.h>

#include <tdelocale.h>
#include <kiconloader.h>
#include <kinstance.h>
#include <tdemessagebox.h>
#include <kstandarddirs.h>
#include <tdetempfile.h>
#include <kdebug.h>
#include <kgenericfactory.h>

#include <kis_global.h>
#include <kis_types.h>
#include <kis_tool.h>
#include <kis_tool_registry.h>
#include "default_tools.h"

#include "kis_tool_fill.h"
#include "kis_tool_brush.h"
#include "kis_tool_freehand.h"
#include "kis_tool_gradient.h"
#include "kis_tool_rectangle.h"
#include "kis_tool_colorpicker.h"
#include "kis_tool_line.h"
#include "kis_tool_text.h"
#include "kis_tool_duplicate.h"
#include "kis_tool_move.h"
#include "kis_tool_zoom.h"
#include "kis_tool_ellipse.h"
#include "kis_tool_pan.h"


typedef KGenericFactory<DefaultTools> DefaultToolsFactory;
K_EXPORT_COMPONENT_FACTORY( chalkdefaulttools, DefaultToolsFactory( "chalk" ) )


DefaultTools::DefaultTools(TQObject *parent, const char *name, const TQStringList &)
    : KParts::Plugin(parent, name)
{
    setInstance(DefaultToolsFactory::instance());

     if ( parent->inherits("KisToolRegistry") )
     {
        KisToolRegistry * r = dynamic_cast<KisToolRegistry*>(parent);

        r->add(new KisToolFillFactory());
        r->add(new KisToolGradientFactory());
        r->add(new KisToolBrushFactory());
        r->add(new KisToolColorPickerFactory());
        r->add(new KisToolLineFactory());
        r->add(new KisToolTextFactory());
        r->add(new KisToolDuplicateFactory());
        r->add(new KisToolMoveFactory());
        r->add(new KisToolZoomFactory());
        r->add(new KisToolEllipseFactory());
        r->add(new KisToolRectangleFactory());
        r->add(new KisToolPanFactory());

        }
}

DefaultTools::~DefaultTools()
{
}

#include "default_tools.moc"
