/* This file is part of the KDE project
   Copyright (C) 2004 Cedric Pasteur <cedric.pasteur@free.fr>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef KEXIREPORTFACTORY_H
#define KEXIREPORTFACTORY_H

#include <widgetfactory.h>

//! Kexi Factory (DB widgets + subform)
class KexiReportFactory : public KFormDesigner::WidgetFactory
{
	Q_OBJECT
  

	public:
		KexiReportFactory(TQObject *parent, const char *name, const TQStringList &args);
		virtual ~KexiReportFactory();

		virtual TQString  name();
		virtual TQWidget *createWidget(const TQCString &classname, TQWidget *parent, const char *name, KFormDesigner::Container *container,
			int options = DefaultOptions);

		virtual bool createMenuActions(const TQCString &classname, TQWidget *w, TQPopupMenu *menu,
		   KFormDesigner::Container *container);
		virtual bool startEditing(const TQCString &classname, TQWidget *w, KFormDesigner::Container *container);
		virtual bool previewWidget(const TQCString &, TQWidget *, KFormDesigner::Container *);

		//virtual void		saveSpecialProperty(const TQString &classname, const TQString &name, const TQVariant &value, TQWidget *w,
		         //TQDomElement &parentNode, TQDomDocument &parent) {}
		//virtual void            readSpecialProperty(const TQCString &classname, TQDomElement &node, TQWidget *w, KFormDesigner::ObjectTreeItem *item) {}
		virtual TQValueList<TQCString> autoSaveProperties(const TQCString &classname);

	public slots:
		void editText();

	protected:
		virtual bool isPropertyVisibleInternal(const TQCString &, TQWidget *, const TQCString &, bool isTopLevel);
//		virtual void changeText(const TQString &newText);
//		virtual void resizeEditor(TQWidget *widget, const TQCString &classname);

	private:
		TQWidget *m_widget;
		KFormDesigner::Container *m_container;
};

#endif

