/* This file is part of the KDE project
   Copyright (C) 2004 - 2006 Dag Andersen <danders@get2net.dk>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation;
   version 2 of the License.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#include "kptsummarytaskgeneralpanel.h"
#include "kptsummarytaskdialog.h"
#include "kpttask.h"
#include "kptcommand.h"
#include "kptconfig.h"
#include "kptpart.h"

#include <tdemessagebox.h>
#include <klineedit.h>
#include <ktextedit.h>
#include <kcombobox.h>
#include <kdatetimewidget.h>
#include <tdelocale.h>
#include <kcommand.h>
#include <tdeabc/addressee.h>
#include <tdeabc/addresseedialog.h>

#include <tqpushbutton.h>
#include <tqlayout.h>
#include <tqlabel.h>
#include <tqdatetime.h> 
#include <tqdatetimeedit.h> 
#include <tqgroupbox.h> 
#include <kdebug.h>

namespace KPlato
{

SummaryTaskGeneralPanel::SummaryTaskGeneralPanel(Task &task, TQWidget *p, const char *n)
    : SummaryTaskGeneralPanelBase(p, n),
      m_task(task)
{
    setStartValues(task);
    
    connect(namefield, TQT_SIGNAL(textChanged(const TQString&)), TQT_SLOT(slotObligatedFieldsFilled()));
    connect(leaderfield, TQT_SIGNAL(textChanged(const TQString&)), TQT_SLOT(slotObligatedFieldsFilled()));
    connect(idfield, TQT_SIGNAL(textChanged(const TQString&)), TQT_SLOT(slotObligatedFieldsFilled()));
    connect(descriptionfield, TQT_SIGNAL(textChanged()), TQT_SLOT(slotObligatedFieldsFilled()));
    
    connect(chooseLeader, TQT_SIGNAL(clicked()), TQT_SLOT(slotChooseResponsible()));

}

void SummaryTaskGeneralPanel::setStartValues(Task &task) {
    namefield->setText(task.name());
    leaderfield->setText(task.leader());
    descriptionfield->setText(task.description());
    idfield->setText(task.id());
    wbsfield->setText(task.wbs());
    
    namefield->setFocus();
    
}

void SummaryTaskGeneralPanel::slotObligatedFieldsFilled() {
    emit obligatedFieldsFilled(!namefield->text().isEmpty() && !idfield->text().isEmpty());
}

KMacroCommand *SummaryTaskGeneralPanel::buildCommand(Part *part) {
    KMacroCommand *cmd = new KMacroCommand(i18n("Modify Task"));
    bool modified = false;

    if (!namefield->isHidden() && m_task.name() != namefield->text()) {
        cmd->addCommand(new NodeModifyNameCmd(part, m_task, namefield->text()));
        modified = true;
    }
    if (!leaderfield->isHidden() && m_task.leader() != leaderfield->text()) {
        cmd->addCommand(new NodeModifyLeaderCmd(part, m_task, leaderfield->text()));
        modified = true;
    }
    if (!descriptionfield->isHidden() && 
        m_task.description() != descriptionfield->text()) {
        cmd->addCommand(new NodeModifyDescriptionCmd(part, m_task, descriptionfield->text()));
        modified = true;
    }
    if (!idfield->isHidden() && idfield->text() != m_task.id()) {
        cmd->addCommand(new NodeModifyIdCmd(part, m_task, idfield->text()));
        modified = true;
    }
    if (!modified) {
        delete cmd;
        return 0;
    }
    return cmd;
}

bool SummaryTaskGeneralPanel::ok() {
    if (idfield->text() != m_task.id() && m_task.findNode(idfield->text())) {
        KMessageBox::sorry(this, i18n("Task id must be unique"));
        idfield->setFocus();
        return false;
    }
    return true;
}

void SummaryTaskGeneralPanel::slotChooseResponsible() {
    TDEABC::Addressee a = TDEABC::AddresseeDialog::getAddressee(this);
    if (!a.isEmpty()) {
        leaderfield->setText(a.fullEmail());
        leaderfield->setFocus();
    }
}


}  //KPlato namespace

#include "kptsummarytaskgeneralpanel.moc"
