/* This file is part of the KDE project
   Copyright (C) 2004 Cedric Pasteur <cedric.pasteur@free.fr>
   Copyright (C) 2007 Jaroslaw Staniek <js@iidea.pl>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef FORMEDITORUTILS_H
#define FORMEDITORUTILS_H

#include <tqptrlist.h>
#include <tqtabbar.h>
#include <tqtabwidget.h>

//! @todo replace TQTabWidget by KTabWidget after the bug with & is fixed:
#define TabWidgetBase TQTabWidget
//#define USE_KTabWidget //todo: uncomment

namespace KFormDesigner {

class Form;

/*! \return parent object of \a o that inherits \a className or NULL if no such parent
 If the parent is found, \a prevPrev is set to a child of child of the parent, 
 what for TabWidget means the page widget. */
template<class type>
type* findParent(TQT_BASE_OBJECT_NAME* o, const char* className, TQObject* &prevPrev)
{
	if (!o || !className || className[0]=='\0')
		return 0;
	TQObject *prev = TQT_TQOBJECT(o);
	while ( ((o=TQT_TQOBJECT(o)->parent())) && !TQT_TQOBJECT(o)->inherits(className) ) {
		prevPrev = prev;
		prev = TQT_TQOBJECT(o);
	}
	return static_cast<type*>(o);
}

//! A tab widget providing information about height of the tab bar.
class KFORMEDITOR_EXPORT TabWidget : public TabWidgetBase
{
	Q_OBJECT
  
	public:
		TabWidget(TQWidget *parent, const char *name) 
		 : TabWidgetBase(parent, name) {}
		virtual ~TabWidget() {}
		int tabBarHeight() const { return tabBar()->height(); }
};

//! @short A list of widget pointers.
typedef TQPtrList<TQWidget> WidgetList;

//! @short An iterator for WidgetList.
typedef TQPtrListIterator<TQWidget> WidgetListIterator;

//! @short A helper for sorting widgets horizontally
class HorWidgetList : public WidgetList
{
	public:
		HorWidgetList(TQWidget *topLevelWidget);
		virtual ~HorWidgetList();
	protected:
		virtual int compareItems(TQPtrCollection::Item item1, TQPtrCollection::Item item2);
		TQWidget *m_topLevelWidget;
};

//! @short A helper for sorting widgets vertically
class VerWidgetList : public WidgetList
{
	public:
		VerWidgetList(TQWidget *topLevelWidget);
		virtual ~VerWidgetList();
	protected:
		virtual int compareItems(TQPtrCollection::Item item1, TQPtrCollection::Item item2);
		TQWidget *m_topLevelWidget;
};

/*! This function is used to remove all the child widgets from a list, and
  keep only the "toplevel" ones. */
KFORMEDITOR_EXPORT void removeChildrenFromList(WidgetList &list);

/*! This helper function install an event filter on \a object and all of its
  children, directed to \a container.
  This is necessary to filter events for composed widgets. */
KFORMEDITOR_EXPORT void installRecursiveEventFilter(TQObject *object, TQObject *container);

/*! This helper function removes an event filter installed before
  on \a object and all of its children.
  This is necessary to filter events for composed widgets. */
KFORMEDITOR_EXPORT void removeRecursiveEventFilter(TQObject *object, TQObject *container);

KFORMEDITOR_EXPORT void setRecursiveCursor(TQWidget *w, Form *form);

/*! \return the size of \a w children. This can be used eg to get widget's sizeHint. */
KFORMEDITOR_EXPORT TQSize getSizeFromChildren(TQWidget *widget, const char *inheritClass=TQWIDGET_OBJECT_NAME_STRING);

}

#endif

