/***************************************************************************
                          knowitlinks.cpp  -  description
                             -------------------
    begin                : nie gru 21 2003
    copyright            : (C) 2003 by Micha Rudolf
    email                : mrudolf@kdewebdev.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "knowitlinks.h"
#include <tqevent.h>
#include <kurldrag.h>

KnowitLinks::KnowitLinks(TQWidget* parent, const char* name)
   : TDEListBox(parent, name)
{
   setAcceptDrops(true);
}

void KnowitLinks::dragEnterEvent(TQDragEnterEvent* event)
{
   event->accept(KURLDrag::canDecode(event));
}

void KnowitLinks::dropEvent(TQDropEvent* event)
{
   if (KURLDrag::canDecode(event)) {
      KURL::List L;
      KURLDrag::decode(event, L);
      for (uint i=0; i<L.count(); i++)
         emit textDropped(L[i].url(), L.count() > 1);
   }
}

void KnowitLinks::keyPressEvent(TQKeyEvent* e)
{
   if (currentItem() != -1 && (e->key() == TQt::Key_Enter || e->key() == TQt::Key_Return)) {
      e->ignore();
      if ((e->state() | Qt::NoButton | TQt::Keypad) ==
         (Qt::NoButton | TQt::Keypad)) emit linkOpen();
      else emit linkOpenWith();
      }
   else if (currentItem() != -1 && e->key() == TQt::Key_Delete) {
      e->ignore();
      emit linkRemove();
      }
   else TDEListBox::keyPressEvent(e);
}
