/***************************************************************************
                          knowittree.h  -  description
                             -------------------
    begin                : sob gru 20 2003
    copyright            : (C) 2003 by Micha Rudolf
    email                : mrudolf@kdewebdev.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef __KNOWIT_TREE_H__
#define __KNOWIT_TREE_H__
#include <tdelistview.h>
class TQDragMoveEvent;
class KnowitTree : public TDEListView
{
  Q_OBJECT
  
public:
  KnowitTree(TQWidget* parent=0, const char* name = 0);
  TQListViewItem* prevItem;
  void takeNode(TQListViewItem* item);
  void insertNode(TQListViewItem* parent, TQListViewItem* item, TQListViewItem* after = 0);
protected:
  virtual void contentsDragMoveEvent(TQDragMoveEvent* event);
public slots:  
  /** Shows only first-level notes */
  void slotCollapseAll();
  /** Shows only root of selected tree */
  void slotCollapse();
  /** Shows all notes */
  void slotExpandAll();
  /** Shows all notes of selected tree */
  void slotExpand();
  /** Move note up */
  void slotItemUp();
  /** Move note down */
  void slotItemDown();
  /** Move note at the beginning of current list */
  void slotItemBegin();
  /** Move note at the end of current list */
  void slotItemEnd();
  /** Move note level up */
  void slotItemLeft();
  /** Move note level down */
  void slotItemRight();
};

#endif

