/***************************************************************************
 *                                                                         *
 *   Copyright (C) 2005, 2006 by Kevin Gilbert                             *
 *   kev.gilbert@cdu.edu.au                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 *                                                                         *
 ***************************************************************************/

#include <ntqiconset.h>
#include <ntqlabel.h>
#include <ntqlayout.h>
#include <ntqlineedit.h>
#include <ntqlistbox.h>
#include <ntqpushbutton.h>
#include <ntqstring.h>
#include <ntqstringlist.h>

#include <kdebug.h>
#include <tdefiledialog.h>
#include <tdeglobalsettings.h>
#include <kiconloader.h>
#include <tdelocale.h>
#include <tdemessagebox.h>

#include "stylesheetdialog.h"

//	constructor
//	===========

StylesheetDialog::StylesheetDialog( const TQString&     currentStylesheetURL,
									const TQStringList& stylesheetURLs,
									TQWidget*           parent,
									const char*        name )
: KDialogBase( Plain, "'man' stylesheet location", Ok | Cancel, Ok, parent, name ),
  m_currentStylesheetURL( currentStylesheetURL ),
  m_stylesheetURLs( stylesheetURLs )
{	TQGridLayout* layout          = new TQGridLayout( plainPage( ));
	TDEIconLoader* iconLoader      = TDEGlobal::iconLoader( );
	TQIconSet     fileOpenIconSet = iconLoader->loadIconSet( "document-open",   TDEIcon::Small );
	TQPushButton* urlButton       = new TQPushButton( fileOpenIconSet, NULL, plainPage( ), "stylesheet url button" );
	m_urlLineEdit                = new TQLineEdit( plainPage( ), "stylesheet url line edit" );
	m_urlListBox                 = new TQListBox( plainPage( ), "stylesheet url list box" );

	m_urlListBox->insertStringList( stylesheetURLs );
	m_urlLineEdit->setMinimumWidth( int( 1.1 * m_urlListBox->maxItemWidth( )));
	m_urlLineEdit->setText( currentStylesheetURL );

	layout->addWidget( new TQLabel( "Stylesheet URL: ", plainPage( ), "url label" ), 1, 1, TQt::AlignRight );
	layout->addWidget( m_urlLineEdit, 1, 2 );
	layout->addWidget( urlButton,     1, 3 );
	layout->addWidget( new TQLabel( "Known URLs: ", plainPage( ), "url label" ), 3, 1, TQt::AlignRight | TQt::AlignTop );
	layout->addWidget( m_urlListBox,  3, 2 );

	layout->setColStretch( 0,  1 );
	layout->setColStretch( 2, 20 );
	layout->setColStretch( 4,  1 );

	layout->setRowStretch( 0,  2 );
	layout->setRowStretch( 2,  1 );
	layout->setRowStretch( 3, 10 );
	layout->setRowStretch( 4,  2 );

	connect( urlButton,    SIGNAL( clicked( )),                     SLOT( slotURLButtonClicked( )));
	connect( m_urlListBox, SIGNAL( doubleClicked( TQListBoxItem* )), SLOT( slotURLListBoxDoubleClicked( TQListBoxItem* )));
}

//	slotOk
//	======

void StylesheetDialog::slotOk( )
{	TQString currentStylesheetURL = m_urlLineEdit->text( );
	TQStringList::Iterator it = m_stylesheetURLs.find( currentStylesheetURL );

	if( it != m_stylesheetURLs.end( ))
		m_stylesheetURLs.remove( it );

	if( !TQFile::exists( currentStylesheetURL ))
	{	KMessageBox::sorry( this, TQString( i18n( "The stylesheet \"%1\" does not exist" )).arg( currentStylesheetURL ), i18n( "Nonexistant stylesheet" ));
		TQListBoxItem* item = m_urlListBox->findItem( currentStylesheetURL, TQt::ExactMatch );

		if( item != NULL )
		{	m_urlListBox->removeItem( m_urlListBox->index( item ));
			emit( stylesheetRemoved( ));
		}

		m_urlLineEdit->clear( );
		return;
	}

	m_stylesheetURLs.push_front( currentStylesheetURL );
	KDialogBase::slotOk( );
}

//	slotURLButtonClicked
//	====================

void StylesheetDialog::slotURLButtonClicked( )
{	TQString filter        = "*.css|CSS files\n*.*|All files";
	TQString startDir      = (m_currentStylesheetURL.isEmpty( )) ? TDEGlobalSettings::documentPath( ) : m_currentStylesheetURL;
	TQString stylesheetURL = KFileDialog::getOpenFileName( startDir, filter, this, "url path dlg" );

	if( stylesheetURL.isEmpty( ))
		return;

	m_urlLineEdit->setText( stylesheetURL );
}

//	slotURLListBoxDoubleClicked
//	===========================

void StylesheetDialog::slotURLListBoxDoubleClicked( TQListBoxItem* item )
{	m_urlLineEdit->setText( item->text( ));
	slotOk( );
}
