/***************************************************************************
                          resource.h  -  description
                             -------------------
    begin                : Tue Jul 17 2001
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef RESOURCE_H
#define RESOURCE_H


/**
  *@author Troy Corbin Jr.
  */

/* KDE */
#include <kapp.h>
#include <tdelocale.h>
#include <kcursor.h>
#include <tdelistview.h>
#include <tdecmdlineargs.h>
/* TQt */
#include <tqstylesheet.h>
#include <tqvaluelist.h>
#include <tqstring.h>
#include <tqstringlist.h>
#include <tqpixmap.h>
#include <tqimage.h>
/* Local */
#include "definitions.h"

class audio;
class KnightsPixCache;
class TabManager;
class Accel;

struct engineResource
{
		TQListViewItem	*Item;
		TQString				Name;
		TQString				Filename;
		TQString				Arguments;
		TQString				LogFile;
		int						Protocol;
		int						Wins;
		int						Losses;
		int						Draws;
		int						CurrentRef;
};

struct serverResource
{
		TQListViewItem *Item;
		TQString				Name;
		TQString				URL;
		TQString				UserName;
		TQString				Password;
		TQString				LogFile;
		TQString				Timeseal;
		bool					StorePass;
		int						Port;
		int						CurrentRef;
};

typedef TQValueList<engineResource> engineList;
typedef TQValueList<serverResource> serverList;

class resource
{
	public:
													/* The current Theme */
		int										ThemeSize;
		bool									ThemeBorder;
		TQStyleSheet						*ConsoleStyle;
		TQString								CurrentBoard;
		TQString								CurrentChessmen;
		TQString								CurrentAudio;
		ThemeHeader						boardHeader;
		ThemeHeader						chessmenHeader;
		ThemeHeader						audioHeader;
		KnightsPixCache				*pixCache;
		TabManager						*tabManager;
		Accel									*myAccel;

													/* General Settings */
		TQString								Local_Player;
		TQString								Local_Email_Address;
		int										Config_Version;
		bool									Accepted_License;
		int										OPTION_On_Init;
		int										Audio_Volume;
		bool 									OPTION_Audio;
		bool									OPTION_Audio_Current_Only;
		bool 									OPTION_Auto_Queen;
		bool 									OPTION_Auto_Preview;
		bool 									OPTION_Auto_Call_Flag;
		bool									OPTION_Auto_Close_Last_ICS;
		bool									OPTION_Animate_Moves;
		bool									OPTION_Book_White;
		bool									OPTION_Book_Black;
		bool									OPTION_Board_Orientation;
		bool									OPTION_Delete_Logs;
		bool									OPTION_Ponder;
		bool									OPTION_Show_Coord;
		bool									OPTION_Show_Last_Move;
		bool									OPTION_Show_Splash;
		bool									OPTION_Show_Extended_PGN;
		bool									OPTION_Pause_On_Minimize;
		bool									OPTION_Reuse_PGN;
		bool									OPTION_3DBoard;
		TQString								PGN_Filename;
		TQString								Email_Command_Line;
		TQString								Email_Address;
		TQString								SCID_Image_Path;
		int										Widget_Height;
													/* ICS Options */
		int										Seek_Timer;
		int										OPTION_Profanity;
		bool									OPTION_Premove;
		bool									OPTION_Kibitz;
		bool									OPTION_Private;
		bool									OPTION_Shout;
		bool									OPTION_Tell;
		bool									OPTION_Seek;
													/* Notification Prompts */
		TQString								PromptForSaving;
													/* Colors */
		TQColor								COLOR_White;
		TQColor								COLOR_Black;
		TQColor								COLOR_Background;
		TQColor								COLOR_Standard;
		TQColor								COLOR_PrivateTell;
		TQColor								COLOR_ChannelTell;
		TQColor								COLOR_Shout;
		TQColor								COLOR_Whisper;
		TQColor								COLOR_Notification;
		TQColor								COLOR_Notation;
		TQColor								COLOR_Notation_Shadow;
		TQColor								COLOR_GraphBackground;
		TQColor								COLOR_GraphForeground;
													/* Fonts */
		TQFont									FONT_Standard;
		TQFont									FONT_PrivateTell;
		TQFont									FONT_ChannelTell;
		TQFont									FONT_Shout;
		TQFont									FONT_Whisper;
		TQFont									FONT_Notification;
													/* Cursors */
		TQCursor								CURSOR_Standard;
		TQCursor								CURSOR_Thinking;
		TQCursor								CURSOR_Text;
													/* Chess Engines */
		engineList						engines;
		engineList::Iterator	enginesIT;
													/* Chess Servers */
		serverList						servers;
		serverList::Iterator	serversIT;
													/* New Match Presets */
		TCPList								TCPWhite;
		TCPList								TCPBlack;
		char									MatchRules;
		char									Type[4];
		char									Strength[4];

													resource( TDECmdLineArgs *args );
													~resource();

		void									ConfigRead( void );
		void									ConfigWrite( void );
		
		void									readThemeDir( void );
		TQString								getBoard( int Index=-1 );
		TQString								getChessmen( int Index=-1 );
		TQString								getSounds( int Index=-1 );
		TQString								themeDir( void );
		void									setTheme( int BoardIndex=-1, int ChessmenIndex=-1 );
		void									setAudio( int AudioIndex=-1 );
		void									resizeTheme( const int &size );

													/**
													Call buildStyle whenever you need to reparse the Resource configuration */
		void									buildStyle( void );
		TQPixmap								LoadIcon( TQString Name, int Group );
		TQPixmap								loadSCIDImage( const TQString &name );
		void									play( const char );

	private:

		TQStyleSheetItem				*SSI_Default;
		TQStyleSheetItem				*SSI_PrivateTell;
		TQStyleSheetItem				*SSI_ChannelTell;
		TQStyleSheetItem				*SSI_Shout;
		TQStyleSheetItem				*SSI_Whisper;
		TQStyleSheetItem				*SSI_Notification;

		TQString								GlobalDataDir;
		TQString								LocalDataDir;

		TQStringList						Boards;
		TQStringList						Chessmen;
		TQStringList						Sounds;
		TDEIconLoader						*Icons;
		audio									*Audio;

		void									ReadEngines( void );
		void									WriteEngines( void );

		void									ReadServers( void );
		void									WriteServers( void );
		
		void									ReadMatchParam( void );
		void									WriteMatchParam( void );
		
		void									ReadColors( void );
		void									WriteColors( void );

		void									ReadFonts( void );
		void									WriteFonts( void );

		/**
			Borrowed from KMail
			Very primitive en/de-cryption so that the password is not
			readable in the config file. But still very easy breakable.
		*/
		TQString								encryptStr( const TQString& inStr ) const;
		TQString								decryptStr( const TQString& inStr ) const;
		TQString								themeURL( const TQString );
		void									loadThemeItem( const TQString& URL, TQImage& Image );
};

#endif
