/***************************************************************************
                          pgn.h  -  description
                             -------------------
    begin                : Mon Jul 30 2001
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PGN_H
#define PGN_H

#include <tdelocale.h>
#include <tdetempfile.h>
#include <tdeio/netaccess.h>
#include <tqobject.h>
#include <tqstring.h>
#include <tqstringlist.h>
#include <tqvaluelist.h>
#include <tqfile.h>
#include <tqtextstream.h>
#include <tqpainter.h>
#include "definitions.h"
#include "resource.h"
#include "knightsmap.h"
#include "match_param.h"

/**
  *@author Troy Corbin Jr.
  */

struct Annotation
{
	int RAV;
	TQString text;
};

typedef TQValueList<ChessMove> MoveList;
typedef KnightsMap<int, Annotation*> Annotations;

class tab_pgnView;

class pgn : public TQObject
{
	Q_OBJECT
  
	public:
		/* Standard PGN Tags */
		TQString 						TAG_Event;
		TQString 						TAG_Site;
		TQString 						TAG_Date;
		TQString 						TAG_Round;
		TQString 						TAG_White;
		TQString 						TAG_Black;
		TQString 						TAG_Result;
		TQString 						TAG_EventDate;
		TQString 						TAG_EventSponsor;
		TQString 						TAG_Section;
		TQString 						TAG_Stage;
		TQString 						TAG_Board;
		TQString 						TAG_WhiteTitle;
		TQString 						TAG_WhiteElo;
		TQString 						TAG_WhiteUSCF;
		TQString 						TAG_WhiteNA;
		TQString 						TAG_WhiteType;
		TQString 						TAG_BlackTitle;
		TQString 						TAG_BlackElo;
		TQString 						TAG_BlackUSCF;
		TQString 						TAG_BlackNA;
		TQString 						TAG_BlackType;
		TQString 						TAG_Opening;
		TQString 						TAG_Variation;
		TQString 						TAG_SubVariation;
		TQString 						TAG_ECO;
		TQString 						TAG_NIC;
		TQString 						TAG_Time;
		TQString 						TAG_UTCTime;
		TQString 						TAG_UTCDate;
		TQString 						TAG_TimeControl;
		TQString 						TAG_SetUp;
		TQString 						TAG_FEN;
		TQString							TAG_Termination;
		TQString							TAG_Annotator;
		TQString							TAG_Mode;
		TQString 						TAG_PlyCount;

		int									File_Position; // Used to scan PGN file
		TQStringList					Move_Data;

		/* The match_param */
		match_param					*Param;

												/* These are used in unfinished save games */
		int									whiteTime;
		int									blackTime;
		TCPList							whiteTCP;
		TCPList							blackTCP;

		TQString							CurrentURL;
		MoveList						Moves;
		Annotations					RAV;
		Annotations					annotations;
		TQStringList					Positions;
		unsigned int				currentIndex;

												pgn( resource *Rsrc=0, match_param *param=NULL );
												~pgn();
		void								clear( void );
		void								init( void );
		int									scan( void );
		bool								load( const int pos=0 );
		bool								save( TQString URL );
		bool								open( const TQString& URL );
		void								print( void );
		TQStringList*				notation( const int format=1 );
		void								close( void );
		static TQString			getNAG( int num );
		TQString							caption( void );

	signals:
		void								processMove( ChessMove );
		void								processSpecial( void );

	public slots:
		bool								loadNext( void );
		void								parseMatchParam( void );
		void								childViewDestroyed( void );

	private:
		resource						*Resource;
		tab_pgnView					*pgnView;
		TQString							tempFile;
		TQString							currentLine;
		TQFile								File;
		TQTextStream					Input;

		TQChar								getch( void );
		TQString							getword( void );
		void								clearTags( void );
		void								parseTag( void );
		void								parseAnnotation( const int fromRAVnum=0 );
		void								parseRAV( void );
		void								parseKnightsData( void );
};

#endif
