/***************************************************************************
                          logic.h  -  description
                             -------------------
    begin                : Sat Sep 29 2001
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef LOGIC_H
#define LOGIC_H

#include <tqstring.h>
#include "definitions.h"
#include "resource.h"
#include "match_param.h"

/**
  *@author Troy Corbin Jr.
  */

const char CF_King	= 0x01;
const char CF_RookQ = 0x02;
const char CF_RookK = 0x04;

class logic
{

	public:
		char				OnMove;
		Position		current[64];
		Chessman		chessman[64];
		ChessMove		chessMove;

		/* This is used for the 50 move rule */
		char				MoveCounter;

								logic( resource *Rsrc=0, match_param *param=0 );
								~logic();
		void				Init( const int Var=Type_Standard );
		void				setBoard( const TQString &board=TQString(), const short ppf=-2 );
		void				setBoardFromFen( const TQString &fen );
		TQString			board( void );
		bool				isChessman( const char ChessmanPtr );
		bool				isCheck( const bool Army );
		bool				isLegal( const bool Army );
		bool				isDraw( const bool Army );
		bool				Move( void );	
		void				HashLegal( const char Man, const bool Recursion=FALSE );
		int					Pointer( const char File, const char Rank );

		bool 				parseCAN( const bool Army );
		bool 				parseSAN( void );
		void				writeCAN( void );
		void				writeSAN( void );

	protected:
		int							CalcPointer( const char File, const char Rank );
		void						_HashLegal( const bool Recursion=FALSE );
		void						clearBoard( void );
		int							getKing( const bool Army );
		void						Init_Standard( void );
		inline void			copyPositions( Position *Src, Position *Dst )
													{ memcpy( Dst, Src, sizeof(Position) << 6 ); }
		inline void			copyChessmen( Chessman *Src, Chessman *Dst )
													{ memcpy( Dst, Src, sizeof(Chessman) << 6 ); }

	private:
		resource		*Resource;
		match_param	*Param;
		int					GameType;
		Position		hash[64];
		Position		hashBackup[64];
		Chessman		chessmanBackup[64];
		char				CastleFlag[2];
		char				enPassant[2];
		char				ManPtr;
};

#endif
